/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.justificatifs;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocumentsByCategory;
import ch.dvbern.tax.ge.pm.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.FSDocumentStore;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UserDocumentsDialog;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDocumentsAction
extends ActionBase
implements ButtonCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDocumentsAction.class);
    private int modus = 0;
    public static final int MODUS_STANDARD = 0;
    public static final int MODUS_TITRES = 1;

    public UserDocumentsAction() {
        super("documents.action", null, "icon.menu.file.dossier");
    }

    public UserDocumentsAction(int modus) {
        super("documents.action", null, "icon.menu.file.dossier");
        this.modus = modus;
    }

    public void init(IButtonItem buttonDTO) {
    }

    public void execute(IButtonItem buttonDTO) {
        this.run();
    }

    public void run() {
        TaxmeController ctrl = TaxmeController.getInstance();
        GeDvbTaxCdSession session = (GeDvbTaxCdSession)ctrl.getTmoCdSession();
        if (session.getFile() == null) {
            if (!DialogUtil.showYesNoDialog((Shell)TaxmeController.getInstance().getShell(), (String)"documents.action.save", (Object[])new Object[0])) {
                return;
            }
            if (!ctrl.saveFile()) {
                return;
            }
        }
        if (this.modus == 0) {
            this.openDocumentStore(ctrl, session);
        } else {
            this.openDocumentStoreTitles(ctrl, session);
        }
    }

    private void openDocumentStore(TaxmeController ctrl, GeDvbTaxCdSession session) {
        try (FSDocumentStore documentStore = session.openDocumentStore();){
            List<RequiredDocumentsByCategory> categories = RequiredDocumentsByCategory.resolveAll(session.getDataModel(), session.getLogicModel());
            UserDocumentsDialog dlg = new UserDocumentsDialog(ctrl.getShell(), documentStore, categories, null);
            dlg.open();
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve document store instance", (Throwable)e);
            DialogUtil.showErrorDialog((Shell)ctrl.getShell(), (String)"documents.action.error", (Object[])new Object[0]);
        }
    }

    private void openDocumentStoreTitles(TaxmeController ctrl, GeDvbTaxCdSession session) {
        try (FSDocumentStore documentStore = session.openDocumentStore();){
            List<RequiredDocumentsByCategory> categories = RequiredDocumentsByCategory.resolveAll(session.getDataModel(), session.getLogicModel());
            List<RequiredDocumentsByCategory> filteredCategories = categories.stream().filter(category -> category.getLabel().equals(Messages.translate((String)"label.justificatifs.category.titres", (Object[])new Object[0]))).collect(Collectors.toList());
            UserDocumentsDialog dlg = new UserDocumentsDialog(ctrl.getShell(), documentStore, filteredCategories, null);
            dlg.open();
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve document store instance", (Throwable)e);
            DialogUtil.showErrorDialog((Shell)ctrl.getShell(), (String)"documents.action.error", (Object[])new Object[0]);
        }
    }
}

