/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.ge.pm.envoi.GeEnvoiConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLMessageBox
extends Dialog {
    private static final Logger LOG = LoggerFactory.getLogger(HTMLMessageBox.class);
    private final String windowTitle;
    private final String htmlContent;
    private final int htmlWidgetWidth;
    private final int htmlWidgetHeight;
    private final int iconId;

    public HTMLMessageBox(Shell parent, int style, String windowTitle, String htmlContent, int htmlWidgetWidth, int htmlwidgetHeight) {
        super(parent);
        this.setShellStyle(65600);
        HTMLMessageBox.validateStyle(style);
        this.iconId = style;
        this.windowTitle = windowTitle;
        this.htmlContent = htmlContent;
        this.htmlWidgetWidth = htmlWidgetWidth;
        this.htmlWidgetHeight = htmlwidgetHeight;
    }

    private static void validateStyle(int style) {
        if (style != 0 && style != 2 && style != 8 && style != 1) {
            throw new IllegalArgumentException("Style not allowed: " + style);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.translate((String)"button.suite", (Object[])new Object[0]), true);
        GeEnvoiConfiguration.getUploadWindowUrl();
    }

    public void create() {
        super.create();
        this.getShell().setText(this.windowTitle);
        Image img = GuiUtil.getImageRegistry().get("icon.window.app");
        if (img != null) {
            this.getShell().setImage(img);
        }
    }

    private String replaceProperties(String htmlContentTemplate) {
        CssStyle css = new CssStyle();
        Color fgColor = this.getShell().getForeground();
        Color bgColor = this.getShell().getBackground();
        Font font = this.getShell().getFont();
        String enrichedContent = htmlContentTemplate;
        css.backgroundColor = "rgb(" + bgColor.getRed() + "," + bgColor.getGreen() + "," + bgColor.getBlue() + ")";
        css.foregroundColor = "rgb(" + fgColor.getRed() + "," + fgColor.getGreen() + "," + fgColor.getBlue() + ")";
        FontData[] allFontData = font.getFontData();
        if (allFontData != null && allFontData.length > 0) {
            FontData fontData = allFontData[0];
            css.fontName = fontData.getName();
            css.fontSize = fontData.getHeight() + "pt";
            css.fontWeight = (fontData.getStyle() & 1) != 0 ? "bold" : "normal";
            css.fontStyle = (fontData.getStyle() & 2) != 0 ? "italic" : "normal";
        }
        enrichedContent = enrichedContent.replace("$$BackgroundColorCSS$$", css.backgroundColor);
        enrichedContent = enrichedContent.replace("$$ForegroundColorCSS$$", css.foregroundColor);
        enrichedContent = enrichedContent.replace("$$FontName$$", css.fontName);
        enrichedContent = enrichedContent.replace("$$FontSizeCSS$$", css.fontSize);
        enrichedContent = enrichedContent.replace("$$FontWeightCSS$$", css.fontWeight);
        enrichedContent = enrichedContent.replace("$$FontStyleCSS$$", css.fontStyle);
        enrichedContent = enrichedContent.replace("$$InheritAllStyles$$", css.getAllStyles());
        return enrichedContent;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        RowLayout containerLayout = new RowLayout(256);
        containerLayout.fill = true;
        container.setLayout((Layout)containerLayout);
        Label iconLabel = new Label(container, 0);
        Image icon = Display.getCurrent().getSystemImage(this.iconId);
        iconLabel.setImage(icon);
        Browser messageBrowser = null;
        try {
            messageBrowser = BrowserUtil.createBrowser((Composite)container);
            RowData mbLayoutData = new RowData(this.htmlWidgetWidth, this.htmlWidgetHeight);
            messageBrowser.setLayoutData((Object)mbLayoutData);
        }
        catch (BrowserNotSupportedException e) {
            LOG.error("Failed to create browser area", (Throwable)e);
            return null;
        }
        String enrichedContent = this.replaceProperties(this.htmlContent);
        messageBrowser.setText(enrichedContent);
        container.pack();
        return container;
    }

    private static final class CssStyle {
        public String backgroundColor = "inherit";
        public String foregroundColor = "inherit";
        public String fontName = "inherit";
        public String fontSize = "inherit";
        public String fontWeight = "inherit";
        public String fontStyle = "inherit";

        public String getBackgroundColorStyle() {
            return "background-color: " + this.backgroundColor + ";";
        }

        public String getForegroundColorStyle() {
            return "color: " + this.foregroundColor + ";";
        }

        public String getFontNameStyle() {
            return "font-name: " + this.fontName + ";";
        }

        public String getFontSizeStyle() {
            return "font-size: " + this.fontSize + ";";
        }

        public String getFontWeightStyle() {
            return "font-weight: " + this.fontWeight + ";";
        }

        public String getFontStyleStyle() {
            return "font-style: " + this.fontStyle + ";";
        }

        public String getAllStyles() {
            return this.getBackgroundColorStyle() + " " + this.getForegroundColorStyle() + " " + this.getFontNameStyle() + " " + this.getFontSizeStyle() + " " + this.getFontWeightStyle() + " " + this.getFontStyleStyle();
        }
    }
}

