/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.PrintAllAction;
import ch.dvbern.tax.common.presentation.cd.action.PrintableAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.dialog.PrintDialog;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.ge.pm.presentation.cd.action.GeEnvoiElectroniqueAction;
import ch.dvbern.tax.ge.pm.utils.GeConstants;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class GePrintOrExportDialog
extends PrintDialog {
    private static final int SINGLE_PRINT_BTN_PER_COL = 9;
    private boolean skipPrint = false;

    public GePrintOrExportDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)"title.shell.print.dialog", (Object[])new Object[0]));
    }

    private Composite createIconPanel(Composite parent, String icon, String msgKey) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 15;
        panel.setLayout((Layout)layout);
        Label printIconLbl = new Label(panel, 0);
        printIconLbl.setImage(GuiUtil.getImageRegistry().get(icon));
        Label printLbl = new Label(panel, 0);
        printLbl.setText(Messages.translate((String)msgKey, (Object[])new Object[0]));
        printLbl.setFont(GuiUtil.getFontRegistry().get("font.header.form"));
        Label emptyLbl = new Label(panel, 0);
        emptyLbl.setVisible(false);
        return panel;
    }

    private Button createReleaseButton(Composite parent, String btnMsgKey, Object action, boolean releaseAllowed) {
        Button btn = new Button(parent, 32);
        btn.setText(Messages.translate((String)btnMsgKey, (Object[])new Object[0]));
        btn.setEnabled(releaseAllowed);
        btn.addSelectionListener((SelectionListener)new PrintDialog.PrintAllSelectionListener((PrintDialog)this));
        btn.setData(action);
        return btn;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.translate((String)"title.print.dialog", (Object[])new Object[0]));
        this.setMessage(Messages.translate((String)"label.print.message", (Object[])new Object[0]));
        this.buttonsAlle.clear();
        TaxmeController ctrl = TaxmeController.getInstance();
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        int stateStek = session.getDataModelState();
        boolean releaseAllowed = stateStek == 1 || stateStek == 2;
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 30;
        layout.marginHeight = 30;
        layout.marginRight = 50;
        panel.setLayout((Layout)layout);
        Composite printPanel = this.createIconPanel(panel, "icon.print", "label.print.alleformulare");
        Composite uploadPanel = this.createIconPanel(panel, "icon.upload", "label.print.upload");
        this.buttonsAlle.add(this.createReleaseButton(printPanel, "label.print.button.alleformulare", new PrintAllAction(), releaseAllowed));
        this.buttonsAlle.add(this.createReleaseButton(uploadPanel, "label.print.upload.button.prepare", (Object)new GeEnvoiElectroniqueAction(this.getShell()), releaseAllowed));
        Label emptyLbl = new Label(uploadPanel, 0);
        emptyLbl.setVisible(false);
        Link uploadFAQLink = new Link(uploadPanel, 0);
        uploadFAQLink.setText(Messages.translate((String)"label.upload.faqlink", (Object[])new Object[0]));
        uploadFAQLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                GePrintOrExportDialog.this.close();
                HelpMainhelpAction help = new HelpMainhelpAction(event.text);
                help.run();
            }
        });
        Composite singlePrintPanel = new Composite(panel, 0);
        GridLayout singlePrintPanelLayout = new GridLayout(2, false);
        singlePrintPanelLayout.horizontalSpacing = 50;
        singlePrintPanel.setLayout((Layout)singlePrintPanelLayout);
        Label singlePrintLbl = new Label(singlePrintPanel, 0);
        singlePrintLbl.setFont(GuiUtil.getFontRegistry().getItalic("font.header.section"));
        singlePrintLbl.setText(Messages.translate((String)"label.print.einzelformulare", (Object[])new Object[0]));
        singlePrintLbl.setLayoutData((Object)new GridData(0x1000000, -1, false, false, 2, 1));
        List navItems = ctrl.getTmoCdSession().getExpertNavigationItems();
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> filteredNavItems = new ArrayList<ExpertDisplayInfoDTO.NavigationDTO>(navItems.size());
        for (ExpertDisplayInfoDTO.NavigationDTO navigationDTO : navItems) {
            if (navigationDTO.isExtraForm()) continue;
            filteredNavItems.add(navigationDTO);
        }
        this.buttonsEinzeln.clear();
        boolean firstCol = true;
        int total = 0;
        int i = 0;
        while (total < filteredNavItems.size()) {
            int effectiveIndex;
            int n = effectiveIndex = firstCol ? i / 2 : i / 2 + 9;
            assert (!firstCol || effectiveIndex < filteredNavItems.size());
            assert (this.buttonsEinzeln.size() <= filteredNavItems.size());
            if (effectiveIndex >= filteredNavItems.size()) {
                emptyLbl = new Label(singlePrintPanel, 0);
                emptyLbl.setVisible(false);
            } else {
                ++total;
                ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)filteredNavItems.get(effectiveIndex);
                Button buttonEinzeln = new Button(singlePrintPanel, 32);
                buttonEinzeln.setData((Object)navigationDTO);
                buttonEinzeln.setText(Messages.translate((String)("nav.expert." + navigationDTO.getFormName()), (Object[])new Object[0]));
                buttonEinzeln.setFont(GuiUtil.getFontRegistry().getItalic("font.normal"));
                int state = navigationDTO.getState();
                buttonEinzeln.setEnabled(state == 1 || state == 2);
                this.buttonsEinzeln.add(firstCol ? effectiveIndex : this.buttonsEinzeln.size(), buttonEinzeln);
            }
            ++i;
            firstCol = !firstCol;
        }
        assert (this.buttonsEinzeln.size() == filteredNavItems.size());
        if (!releaseAllowed) {
            Label warningLbl = new Label(panel, 64);
            GridData gdData = new GridData(0x1000000, 1024, false, false);
            gdData.widthHint = 250;
            warningLbl.setLayoutData((Object)gdData);
            warningLbl.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            warningLbl.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            warningLbl.setText(Messages.translate((String)"label.print.warnung.nicht.gruen", (Object[])new Object[0]));
        }
        return panel;
    }

    protected void okPressed() {
        GeEnvoiElectroniqueAction action = null;
        for (Button button : this.buttonsAlle) {
            if (!button.getSelection() || !(button.getData() instanceof GeEnvoiElectroniqueAction)) continue;
            action = (GeEnvoiElectroniqueAction)((Object)button.getData());
            break;
        }
        if (action != null) {
            action.run();
            this.skipPrint = true;
        }
        super.okPressed();
    }

    protected PrintableAction buildPrintAction() {
        if (!this.skipPrint) {
            final PrintableAction printAction = super.buildPrintAction();
            if (printAction == null) {
                return null;
            }
            return new PrintableAction(){

                public List<FormKey> getFormKeys() {
                    return printAction.getFormKeys();
                }

                public FormRendererConfiguration getConfiguration() {
                    return GeConstants.initPrintConfiguration(printAction.getConfiguration());
                }
            };
        }
        return null;
    }
}

