/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileOpenAction;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeFileOpenAction
extends FileOpenAction {
    private static final Logger LOG = LoggerFactory.getLogger(GeFileOpenAction.class);

    public void run() {
        if (!TaxmeController.getInstance().askForSave()) {
            return;
        }
        FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        dlg.setFilterPath(TaxmeConfig.getSaveDir().getAbsolutePath());
        dlg.setFilterExtensions(new String[]{"*" + TaxFileConfig.getInstance().getFileNameExtension()});
        String fileName = dlg.open();
        if (fileName != null) {
            TaxmeController.getInstance().openFile(new File(fileName), true);
            if (TaxmeController.getInstance().isDeclarationOpen()) {
                try {
                    TaxFile file = TaxmeController.getInstance().getTmoCdSession().getTaxFile();
                    List attachments = file.getAttachments();
                    boolean[] errorShown = new boolean[]{false};
                    attachments.forEach(item -> {
                        if (!(item.getFileName().startsWith("doc/") || item.getFileName().endsWith("index.json") || item.getFileName().endsWith(".dat"))) {
                            if (!errorShown[0] && !DialogUtil.showConfirmDialog((Shell)TaxmeController.getInstance().getShell(), (String)"old.attachments.error.info", (Object[])new Object[0])) {
                                TaxmeController.getInstance().close();
                            } else {
                                errorShown[0] = true;
                                try {
                                    file.removeAttachment(item);
                                }
                                catch (IOException e) {
                                    LOG.error("Failed to remove old attachments from the file  {}", (Object)file.toString(), (Object)e);
                                }
                            }
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error("Failed to remove old attachments from the file", (Throwable)e);
                }
            }
        }
    }
}

