/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd;

import ch.dvbern.lib.cryptutil.readers.PKCS8PEMCertReader;
import ch.dvbern.lib.update.signatures.MultiMethodSignatureVerifier;
import ch.dvbern.lib.update.signatures.SignMethod;
import ch.dvbern.lib.update.signatures.SignatureVerifier;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeLauncher;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.ButtonOpenLinkAction;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.presentation.cd.wizard.FormNavigationPart;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.ge.pm.presentation.cd.DataResourceImpl;
import ch.dvbern.tax.ge.pm.presentation.cd.GeTaxWindow;
import ch.dvbern.tax.ge.pm.presentation.cd.action.CaseInitAction;
import ch.dvbern.tax.ge.pm.presentation.cd.action.GeFileOpenAction;
import ch.dvbern.tax.ge.pm.presentation.cd.action.GePrintAction;
import ch.dvbern.tax.ge.pm.presentation.cd.action.UtilInfoMandataireAction;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UserDocumentsAction;
import ch.dvbern.tax.ge.pm.presentation.cd.upload.ReleaseAction;
import ch.dvbern.tax.ge.pm.presentation.cd.util.GeCdApplicationConfig;
import ch.dvbern.tax.ge.pm.presentation.cd.util.TaxmeGeFilename;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public final class TaxmeGeLauncher {
    public static final String SIGNED_KEY_NAME_PROD = "ge-signing_PROD.pub";

    private TaxmeGeLauncher() {
    }

    public static void main(String[] args) {
        TaxmeConfig.load((File)new File("config/cd/app-config.properties"));
        TaxmeConfig.setDataResource((DataResource)new DataResourceImpl());
        TaxmeConfig.setExpertModeEnabled((boolean)true);
        TaxmeConfig.setWizardModeEnabled((boolean)false);
        TaxmeConfig.setValue((String)"user.savedir", (String)TaxmeConfig.getString((String)"user.savedir"));
        TaxmeConfig.setValue((String)"user.importdir", (String)TaxmeConfig.getString((String)"user.importdir"));
        TaxmeConfig.setValue((String)"user.printdir", (String)TaxmeConfig.getString((String)"user.printdir"));
        TaxmeConfig.setValue((String)"user.exportdir", (String)TaxmeConfig.getString((String)"user.exportdir"));
        TaxmeConfig.setValue((String)"user.config", (String)TaxmeConfig.getString((String)"user.config"));
        TaxmeConfig.setValue((String)"file.history.size", (String)TaxmeConfig.getString((String)"file.history.size"));
        MultiMethodSignatureVerifier updateVerifier = TaxmeGeLauncher.readUpdateSignatureCertificate();
        TaxmeConfig.setUpdateSignatureVerifier((SignatureVerifier)updateVerifier);
        ExpertDisplayUtil.registerColor((String)"mycolor", (ColorDTO)new ColorDTO(0, 0, 255));
        ExpertDisplayUtil.registerColor((String)"output", (ColorDTO)new ColorDTO(221, 219, 221));
        ActionRegistry reg = ActionRegistry.getInstance();
        reg.registerAction("init", (Action)new CaseInitAction());
        reg.registerAction("treuhand", (Action)new UtilInfoMandataireAction());
        reg.registerAction("print", (Action)new GePrintAction());
        reg.registerAction("open", (Action)new GeFileOpenAction());
        ButtonCommands.register((String)"/print.cmd", (ButtonCommand)new GePrintAction());
        ButtonCommands.register((String)"/release.cmd", (ButtonCommand)new ReleaseAction());
        ButtonCommands.register((String)"/add.document.cmd", (ButtonCommand)new UserDocumentsAction(1));
        GuiUtil.getImageRegistry().put("icon.GE", TaxmeGeLauncher.createIconDesc("GE_icon.gif"));
        GuiUtil.getImageRegistry().put("icon.CH", TaxmeGeLauncher.createIconDesc("CH_icon.gif"));
        reg.addCustomMenuAction("menu.docs", (Action)new ButtonOpenLinkAction("label.menu.documents.document_1", "https://www.ge.ch/c/imp-guides-getaxpm", "icon.GE", false));
        reg.addCustomMenuAction("menu.docs", (Action)new ButtonOpenLinkAction("label.menu.documents.document_2", "https://www.ge.ch/c/guidepm2025sa", "icon.GE", false));
        reg.addCustomMenuAction("menu.docs", (Action)new ButtonOpenLinkAction("label.menu.documents.document_3", "https://www.ge.ch/c/guidepm2025af", "icon.GE", false));
        reg.addCustomMenuAction("menu.docs", (Action)new ButtonOpenLinkAction("label.menu.documents.document_4", "https://www.ge.ch/c/imp-difi", "icon.GE", false));
        reg.addCustomMenuAction("menu.docs", (Action)new ButtonOpenLinkAction("label.menu.documents.document_5", "https://www.ge.ch/c/imp-difi", "icon.GE", false));
        reg.addCustomMenuAction("menu.docs", (Action)new ButtonOpenLinkAction("label.menu.documents.document_6", "https://www.ge.ch/c/imp-difi", "icon.GE", false));
        reg.addCustomMenuAction("menu.docs", (Action)new ButtonOpenLinkAction("label.menu.documents.document_7", "https://www.ge.ch/document/election-domicile-entreprises-personnes-morales", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_9", "https://www.ge.ch/lc/calcul-impot-sa", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_10", "https://www.ge.ch/lc/calcul-impot-af", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_1", "https://www.ge.ch/inscription-aux-e-demarches/inscription-entreprises", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_2", "https://www.ge.ch/remplir-declaration-fiscale-mon-entreprise/demander-delai-declaration-mon-entreprise", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_3", "https://www.ge.ch/publication?titre=information+fiscale&type=182&dossier=All&organisation=51", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_4", "https://www.estv.admin.ch/estv/fr/accueil/impot-anticipe/taux-dinteret.html", "icon.CH", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_5", "https://www.admin.ch/opc/fr/classified-compilation/19900333/index.html", "icon.CH", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_6", "https://www.admin.ch/opc/fr/classified-compilation/19900329/index.html", "icon.CH", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_7", "https://silgeneve.ch/legis/program/books/RSG/htm/rsg_d3_15.htm", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_8", "https://silgeneve.ch/legis/program/books/RSG/htm/rsg_d3_17.htm", "icon.GE", false));
        reg.addCustomMenuAction("menu.links", (Action)new ButtonOpenLinkAction("label.menu.links.link_11", "https://www.ge.ch/impot-societes/obligations-fiscales-lors-liquidation", "icon.GE", false));
        GuiUtil.getImageRegistry().put("icon.print", TaxmeGeLauncher.createIconDesc("print-only.gif"));
        TaxFileConfig.setInstance((TaxFileConfig)new TaxmeGeFilename());
        FormNavigationPart.setOkCancelPostion((int)2);
        GeCdApplicationConfig appConfig = new GeCdApplicationConfig();
        ApplicationConfig.setInstance((ApplicationConfig)appConfig);
        Taxme.setImplementation(GeTaxWindow.class);
        TaxmeLauncher.launchTaxme();
    }

    private static ImageDescriptor createIconDesc(String name) {
        try {
            URL url = new URL("file:" + TaxmeConfig.getIconFilePath((String)name));
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed url", e);
        }
    }

    @Nonnull
    private static MultiMethodSignatureVerifier readUpdateSignatureCertificate() {
        MultiMethodSignatureVerifier multiMethodSignatureVerifier;
        block8: {
            String resourcePath = TaxmeGeLauncher.buildCertificateResourcePath(SIGNED_KEY_NAME_PROD);
            InputStream cert = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            try {
                MultiMethodSignatureVerifier updateVerifier;
                multiMethodSignatureVerifier = updateVerifier = new MultiMethodSignatureVerifier((PublicKey)new PKCS8PEMCertReader(cert).readPublicKey(), Arrays.asList(SignMethod.SHA256withRSA, SignMethod.SHA512withRSA), "");
                if (cert == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cert != null) {
                        try {
                            cert.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not read certificate for update verification @" + resourcePath, e);
                }
            }
            cert.close();
        }
        return multiMethodSignatureVerifier;
    }

    @Nonnull
    private static String buildCertificateResourcePath(@NonNull String filename) {
        String resourceDir = TaxmeConfig.getString((String)"update-site.certpath");
        if (StringUtils.isBlank((CharSequence)resourceDir)) {
            resourceDir = "certs/prod";
        }
        return resourceDir + "/" + filename;
    }
}

