/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.BaremeImpotDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDatabaseDTO;
import ch.dvbern.tax.ge.pm.transfer.dto.ExchangeRatesDTO;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataResourceImpl
implements DataResource {
    private static final Logger LOG = LoggerFactory.getLogger(DataResourceImpl.class);
    private static final String ERROR_READING_FILE = "error reading file ";
    private static final String ERROR_PARSING_FILE = "error parsing file ";
    private static final char QUOTE = '\"';
    private static final char SEMICOLON = ';';
    private static final char TAB = '\t';
    private static final String SPACE = " ";
    private static final String TXT = ".txt";
    private static final String COMMENT = "#";
    private static final String EQUALS = "=";
    private static final int MAX_INPUT_FILE_LINES = 50000;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd.MM.yyyy");
    private static final String ENCODING = "UTF-8";
    private static Map<String, String> constants;
    private static Map<String, OptionItemDTO> communesGeneve;
    private static Map<String, OptionItemDTO> communesGeneveForAnnexeF;
    private static Map<String, OptionItemDTO> cantons;
    private static Map<String, OptionItemDTO> allCantons;
    private static Map<String, OptionItemDTO> pays;
    private static Map<String, OptionItemDTO> cantonsEtPays;
    private static Map<String, OptionItemDTO> cantonsEtPaysForAnnexeF;
    private static Map<String, OptionItemDTO> communesGeneveEtCantons;
    private static Map<Long, Map<String, OptionItemDTO>> communesCantonsPays;
    private static Map<String, OptionItemDTO> communesCantonsPaysChoix;
    private static Map<Long, Double> centimesAdditionnels;
    private static Map<String, Object> barcode;
    private static Map<Long, String> communesToDisplay;
    private static Map<String, OptionItemDTO> mutations;
    private static Map<String, OptionItemDTO> genreRendement;
    private static Map<String, OptionItemDTO> monnaies;
    private static Map<String, OptionItemDTO> actifsSiegeOuLocalises;
    private static Map<String, OptionItemDTO> actifsMobiles;
    private static Map<String, OptionItemDTO> capitalDotation;
    private static Map<String, OptionItemDTO> selonTotalOuAppreciation;
    private static final Map<String, Map<String, OptionItemDTO>> fileContents;
    private static Map<Long, ValorDatabaseDTO> valoren;
    private static Map<String, OptionItemDTO> tauxCapitalisationAnnexeF;
    private static Map<String, BigDecimal> tauxAnnexeG;
    private static Map<String, BigDecimal> tauxAnnexeGYearMinus1;
    private static Map<String, BigDecimal> tauxAnnexeGYearMinus2;
    private static Map<Double, BaremeImpotDTO> baremeImpotBenefice;
    private static Map<Double, BaremeImpotDTO> baremeImpotCapital;
    private static final Map<String, ExchangeRatesDTO> exchangeRates;
    private static final String fileDelimiter = "\t";
    private static final String fileDir;
    private static final String fileConstants;
    private static final String fileValoren;
    private static final String fileMutations;
    private static final String fileGenreRendement;
    private static final String fileCommunesCantonsPaysChoix;
    private static final String fileCommunesCantonsPays;
    private static final String fileMonnaies;
    private static final String fileActifsSiegeOuLocalises;
    private static final String fileActifsMobiles;
    private static final String fileCapitalDotation;
    private static final String fileSelonTotalOuAppreciation;
    private static final String fileTauxAnnexeG;
    private static final String fileTauxCapitalisationAnnexeF;
    private static final String fileTauxAnnexeGYearMinus1;
    private static final String fileTauxAnnexeGYearMinus2;
    private static final String fileTaux;
    private static final String fileBaremeImpotBenefice;
    private static final String fileBaremeImpotCapital;
    private static final String FILE_EXCHANGE_RATES;
    private static final String FILE_QUANTITY_CURRENCY;
    private static final String FILE_EXCHANGE_RATES_YEAR_MINUS_1;
    private static final String FILE_EXCHANGE_RATES_YEAR_MINUS_2;
    private static final String TYPE_LIEU_COMMUNE = "1";
    private static final String TYPE_LIEU_CANTON = "2";
    private static final String TYPE_LIEU_PAYS = "3";
    private static final String CANTON_DE_GENEVE = "9025";
    private static final String PAYS_SUISSE = "8100";
    private static final String CONSTANTS = "constants";
    private static final String COMMUNES_GENEVE = "communesGeneve";
    private static final String CANTONS = "cantons";
    private static final String ALL_CANTONS = "allCantons";
    private static final String PAYS = "pays";
    private static final String CANTONS_ET_PAYS = "cantonsEtPays";
    private static final String COMMUNES_GENEVE_ET_CANTONS = "communesGeneveEtCantons";
    private static final String COMMUNESCANTONSPAYS = "communesCantonsPays";
    private static final String COMMUNESCANTONSPAYSCHOIX = "communesCantonsPaysChoix";
    private static final String COMMUNES_TO_DISPLAY = "communesToDisplay";
    private static final String VALEUR = "valor";
    private static final String MUTATIONS = "mutations";
    private static final String GENRE_RENDEMENT = "genreRendement";
    private static final String MONNAIES = "monnaies";
    private static final String ACTIFS_SIEGEOULOCALISES = "actifsSiegeOuLocalises";
    private static final String ACTIFS_MOBILES = "actifsMobiles";
    private static final String CAPITAL_DOTATION = "capitalDotation";
    private static final String SELON_TOTALOUAPPRECIATION = "selonTotalOuAppreciation";
    public static final String TAUX_ANNEXE_G = "tauxAnnexeG";
    public static final String TAUX_CAPITALISATION_ANNEXE_F = "tauxCapitalisation";
    public static final String TAUX_ANNEXE_G_YEAR_MINUS_1 = "tauxAnnexeGYearMinus1";
    public static final String TAUX_ANNEXE_G_YEAR_MINUS_2 = "tauxAnnexeGYearMinus2";
    public static final String TAUX = "taux";
    private static final String CENTIMES_ADDITIONNELS = "centimesAdditionnels";
    private static final String COMMUNES_GENEVE_FOR_ANNEXE_F = "communesGeneveForAnnexeF";
    private static final String CANTONS_ET_PAYS_FOR_ANNEXE_F = "cantonsEtPaysForAnnexeF";
    private static final String BAREME_IMPOT_BENEFICE = "baremeImpotBenefice";
    private static final String BAREME_IMPOT_CAPITAL = "baremeImpotCapital";
    private static final String BARCODE = "barcode";
    private static final String EXCHANGE_RATES = "exchangeRates";
    public static final String FILE_QUANTITY = "fileQuantity";

    public Double readQuantityCurrency(@NonNull String monnaie) {
        try {
            String line;
            BufferedReader in = DataResourceImpl.getReader(FILE_QUANTITY_CURRENCY);
            Double result = null;
            while ((line = in.readLine()) != null) {
                String[] record;
                if (line.startsWith(COMMENT) || !(record = line.split(fileDelimiter))[0].equals(monnaie) || record.length <= 1) continue;
                result = this.asDouble(record[1]);
            }
            in.close();
            return result != null ? result : 1.0;
        }
        catch (IOException ioe) {
            LOG.error("error reading file {}", (Object)FILE_QUANTITY_CURRENCY, (Object)ioe);
            return 1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(@NonNull String code, @Nullable Object arg1, @Nullable Object arg2) {
        switch (code) {
            case "constants": {
                if (constants == null) {
                    this.readConstants();
                }
                return constants;
            }
            case "communesGeneve": {
                if (communesGeneve == null) {
                    this.readCommunesGeneve();
                }
                return communesGeneve;
            }
            case "communesGeneveForAnnexeF": {
                if (communesGeneveForAnnexeF == null) {
                    this.readCommunesGeneve();
                }
                return communesGeneveForAnnexeF;
            }
            case "cantons": {
                if (cantons == null) {
                    this.readCantons();
                }
                return cantons;
            }
            case "allCantons": {
                if (allCantons == null) {
                    this.readAllCantons();
                }
                return allCantons;
            }
            case "pays": {
                if (pays == null) {
                    this.readPays();
                }
                return pays;
            }
            case "cantonsEtPays": {
                if (cantonsEtPays == null) {
                    this.readCantonsEtPays();
                }
                return cantonsEtPays;
            }
            case "cantonsEtPaysForAnnexeF": {
                if (cantonsEtPaysForAnnexeF == null) {
                    this.readCantonsEtPays();
                }
                return cantonsEtPaysForAnnexeF;
            }
            case "communesGeneveEtCantons": {
                if (communesGeneveEtCantons == null) {
                    this.readCommunesGeneveEtCantons();
                }
                return communesGeneveEtCantons;
            }
            case "communesCantonsPaysChoix": {
                if (communesCantonsPaysChoix == null) {
                    this.readCommunesCantonsPaysChoix();
                }
                return communesCantonsPaysChoix;
            }
            case "communesCantonsPays": {
                Map<String, OptionItemDTO> m;
                if (communesCantonsPays == null) {
                    this.readCommunesCantonsPays();
                }
                if ((m = communesCantonsPays.get(arg1)) != null) {
                    return m;
                }
                return new HashMap();
            }
            case "communesToDisplay": {
                if (communesToDisplay == null) {
                    this.readCommunesCantonsPays();
                }
                return communesToDisplay;
            }
            case "centimesAdditionnels": {
                if (centimesAdditionnels == null) {
                    this.readCommunesGeneve();
                }
                return centimesAdditionnels;
            }
            case "monnaies": {
                if (monnaies == null) {
                    this.readMonnaies();
                }
                return monnaies;
            }
            case "actifsSiegeOuLocalises": {
                if (actifsSiegeOuLocalises == null) {
                    this.readActifSiegeOuLocalises();
                }
                return actifsSiegeOuLocalises;
            }
            case "actifsMobiles": {
                if (actifsMobiles == null) {
                    this.readActifsMobiles();
                }
                return actifsMobiles;
            }
            case "capitalDotation": {
                if (capitalDotation == null) {
                    this.readCapitalDotation();
                }
                return capitalDotation;
            }
            case "selonTotalOuAppreciation": {
                if (selonTotalOuAppreciation == null) {
                    this.readSelonTotalOuAppreciation();
                }
                return selonTotalOuAppreciation;
            }
            case "mutations": {
                if (mutations == null) {
                    this.readMutations();
                }
                return mutations;
            }
            case "genreRendement": {
                if (genreRendement == null) {
                    this.readGenreRendement();
                }
                return genreRendement;
            }
            case "valor": {
                String string = VALEUR;
                synchronized (VALEUR) {
                    if (valoren == null) {
                        this.readValoren();
                    }
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return valoren;
                }
            }
            case "tauxCapitalisation": {
                if (arg1 != null) {
                    tauxCapitalisationAnnexeF = this.readTauxCapitalisation((Boolean)arg1, fileTauxCapitalisationAnnexeF);
                }
                return tauxCapitalisationAnnexeF;
            }
            case "tauxAnnexeG": {
                if (tauxAnnexeG == null) {
                    tauxAnnexeG = this.readModelConfig(fileTauxAnnexeG);
                }
                return tauxAnnexeG;
            }
            case "tauxAnnexeGYearMinus1": {
                if (tauxAnnexeGYearMinus1 == null) {
                    tauxAnnexeGYearMinus1 = this.readModelConfig(fileTauxAnnexeGYearMinus1);
                }
                return tauxAnnexeGYearMinus1;
            }
            case "tauxAnnexeGYearMinus2": {
                if (tauxAnnexeGYearMinus2 == null) {
                    tauxAnnexeGYearMinus2 = this.readModelConfig(fileTauxAnnexeGYearMinus2);
                }
                return tauxAnnexeGYearMinus2;
            }
            case "baremeImpotBenefice": {
                if (baremeImpotBenefice == null) {
                    this.readBaremeImpotBenefice();
                }
                return baremeImpotBenefice;
            }
            case "baremeImpotCapital": {
                if (baremeImpotCapital == null) {
                    this.readBaremeImpotCapital();
                }
                return baremeImpotCapital;
            }
            case "barcode": {
                if (barcode == null) {
                    this.readBarcode(code);
                }
                return barcode;
            }
            case "exchangeRates": {
                String monnaie = (String)arg1;
                if (monnaie == null) {
                    return new LinkedHashMap();
                }
                if (!exchangeRates.containsKey(monnaie)) {
                    LinkedHashMap<Date, Double> xChgMap = this.readExchangeRates(monnaie);
                    exchangeRates.put(monnaie, new ExchangeRatesDTO(monnaie, xChgMap));
                }
                return exchangeRates.get(monnaie).getXchangeMap();
            }
        }
        Map<String, Map<String, OptionItemDTO>> map = fileContents;
        synchronized (map) {
            Map<String, OptionItemDTO> myMap = fileContents.get(code);
            if (myMap == null) {
                myMap = this.readFile(code);
                fileContents.put(code, myMap);
            }
            return myMap;
        }
    }

    private void readConstants() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String line;
            BufferedReader in = DataResourceImpl.getReader(fileConstants);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                Object[] tokens = line.split(fileDelimiter);
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Invalid syntax in constant file: " + Arrays.toString(tokens));
                }
                String key = tokens[0].trim();
                Object value = tokens[1];
                if (key.length() == 0) {
                    throw new IllegalArgumentException("Constant key cannot be empty");
                }
                result.put(key, (String)value);
            }
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileConstants, (Throwable)e);
        }
        constants = result;
    }

    private Map<String, OptionItemDTO> readFile(@NonNull String code) {
        LinkedHashMap<String, OptionItemDTO> result = new LinkedHashMap<String, OptionItemDTO>();
        try {
            BufferedReader in = DataResourceImpl.getReader(fileDir + code + TXT);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith(COMMENT)) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String key = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    result.put(key, new OptionItemDTO((Object)key, null, value, false));
                }
                line = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileDir + code + TXT, (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, OptionItemDTO> getLocalized(@NonNull String code, @Nullable Object arg1, @Nullable Object arg2) {
        Map<String, Map<String, OptionItemDTO>> map = fileContents;
        synchronized (map) {
            Map<String, Object> myMap = fileContents.get(code);
            if (myMap == null) {
                myMap = this.readLocalizedFile(code);
                fileContents.put(code, myMap);
            }
            return myMap;
        }
    }

    private void readCommunesGeneve() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            LinkedHashMap<Long, Double> mapForCA = new LinkedHashMap<Long, Double>();
            LinkedHashMap<String, OptionItemDTO> mapForAnnexeF = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if (!typeLieu.equals(TYPE_LIEU_COMMUNE)) continue;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                myMap.put(codeLieu.toString(), optionItemDTO);
                mapForCA.put(codeLieu, Double.valueOf(tauxCentimesAdditionnels));
                OptionItemDTO optionItemDTOforAnnexeF = new OptionItemDTO((Object)codeLieu, sCodeLieu, codeEtLieu, false);
                mapForAnnexeF.put(codeLieu.toString(), optionItemDTOforAnnexeF);
            }
            communesGeneve = myMap;
            centimesAdditionnels = mapForCA;
            communesGeneveForAnnexeF = mapForAnnexeF;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPays, (Throwable)e);
        }
    }

    private void readCantons() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                tokenizer.nextToken();
                if (!typeLieu.equals(TYPE_LIEU_CANTON) || sCodeLieu.equalsIgnoreCase(CANTON_DE_GENEVE)) continue;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                myMap.put(codeLieu.toString(), optionItemDTO);
            }
            cantons = myMap;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPays, (Throwable)e);
        }
    }

    private void readAllCantons() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                tokenizer.nextToken();
                if (!typeLieu.equals(TYPE_LIEU_CANTON)) continue;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                myMap.put(codeLieu.toString(), optionItemDTO);
            }
            allCantons = myMap;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPays, (Throwable)e);
        }
    }

    private void readPays() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myPays = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                tokenizer.nextToken();
                String lieu = tokenizer.nextToken();
                tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                tokenizer.nextToken();
                if (!typeLieu.equals(TYPE_LIEU_PAYS)) continue;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)lieu, lieu, lieu, false);
                myPays.put(lieu, optionItemDTO);
            }
            pays = myPays;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPays, (Throwable)e);
        }
    }

    private void readCantonsEtPays() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            LinkedHashMap<String, OptionItemDTO> mapForAnnexeF = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if (!typeLieu.equals(TYPE_LIEU_CANTON) && !typeLieu.equals(TYPE_LIEU_PAYS) || sCodeLieu.equalsIgnoreCase(CANTON_DE_GENEVE) || sCodeLieu.equalsIgnoreCase(PAYS_SUISSE)) continue;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, SPACE, lieu, false);
                myMap.put(codeLieu.toString(), optionItemDTO);
                OptionItemDTO optionItemDTOforAnnexeF = new OptionItemDTO((Object)codeLieu, sCodeLieu, codeEtLieu, false);
                mapForAnnexeF.put(codeLieu.toString(), optionItemDTOforAnnexeF);
            }
            cantonsEtPays = myMap;
            cantonsEtPaysForAnnexeF = mapForAnnexeF;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPays, (Throwable)e);
        }
    }

    private void readCommunesCantonsPaysChoix() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> m = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPaysChoix);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String communesCantonsPays = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, SPACE, communesCantonsPays, false);
                m.put(id.toString(), optionItemDTO);
            }
            communesCantonsPaysChoix = m;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPaysChoix, (Throwable)e);
        }
    }

    private void readCommunesCantonsPays() {
        try {
            String line;
            LinkedHashMap<Long, Map<String, OptionItemDTO>> communesCantonsPaysChoix = new LinkedHashMap<Long, Map<String, OptionItemDTO>>();
            LinkedHashMap<Long, String> mapForCommunesToDisplay = new LinkedHashMap<Long, String>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                Long lTypeLieu = Long.valueOf(typeLieu);
                tokenizer.nextToken();
                if (sCodeLieu.equalsIgnoreCase(CANTON_DE_GENEVE) || sCodeLieu.equalsIgnoreCase(PAYS_SUISSE)) continue;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                LinkedHashMap<String, OptionItemDTO> j = (LinkedHashMap<String, OptionItemDTO>)communesCantonsPaysChoix.get(lTypeLieu);
                if (j == null) {
                    j = new LinkedHashMap<String, OptionItemDTO>();
                    communesCantonsPaysChoix.put(lTypeLieu, j);
                    mapForCommunesToDisplay.put(codeLieu, lieu);
                }
                j.put(codeLieu.toString(), optionItemDTO);
            }
            communesCantonsPays = communesCantonsPaysChoix;
            communesToDisplay = mapForCommunesToDisplay;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPays, (Throwable)e);
        }
    }

    private void readCommunesGeneveEtCantons() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                tokenizer.nextToken();
                if (!typeLieu.equals(TYPE_LIEU_COMMUNE) && !typeLieu.equals(TYPE_LIEU_CANTON)) continue;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                myMap.put(codeLieu.toString(), optionItemDTO);
            }
            communesGeneveEtCantons = myMap;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCommunesCantonsPays, (Throwable)e);
        }
    }

    private void readMonnaies() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> kt = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileMonnaies);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String monnaiesShort = tokenizer.nextToken();
                String monnaies = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, monnaiesShort, monnaiesShort, false);
                kt.put(id.toString(), optionItemDTO);
            }
            monnaies = kt;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileMonnaies, (Throwable)e);
        }
    }

    private Map readTauxCapitalisation(Boolean thisYear, @NonNull String filePath) {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> kt = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(filePath);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                String[] params = line.split(fileDelimiter);
                String value = params[0];
                String description = params[1];
                Boolean isThisYear = Boolean.valueOf(params[2]);
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)value, SPACE, description, false);
                if ((!isThisYear.booleanValue() || !thisYear.booleanValue()) && (isThisYear.booleanValue() || thisYear.booleanValue())) continue;
                kt.put(value, optionItemDTO);
            }
            in.close();
            return kt;
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileTauxCapitalisationAnnexeF, (Throwable)e);
            return new HashMap();
        }
    }

    private void readActifSiegeOuLocalises() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileActifsSiegeOuLocalises);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String actifsSiegeOuLocalises = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, SPACE, actifsSiegeOuLocalises, false);
                myMap.put(id.toString(), optionItemDTO);
            }
            actifsSiegeOuLocalises = myMap;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileActifsSiegeOuLocalises, (Throwable)e);
        }
    }

    private void readActifsMobiles() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileActifsMobiles);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String actifsMobiles = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, SPACE, actifsMobiles, false);
                myMap.put(id.toString(), optionItemDTO);
            }
            actifsMobiles = myMap;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileActifsMobiles, (Throwable)e);
        }
    }

    private void readCapitalDotation() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCapitalDotation);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String capitalDotation = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, SPACE, capitalDotation, false);
                myMap.put(id.toString(), optionItemDTO);
            }
            capitalDotation = myMap;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileCapitalDotation, (Throwable)e);
        }
    }

    private void readSelonTotalOuAppreciation() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileSelonTotalOuAppreciation);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String selonTotalOuAppreciation = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, SPACE, selonTotalOuAppreciation, false);
                myMap.put(id.toString(), optionItemDTO);
            }
            selonTotalOuAppreciation = myMap;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileSelonTotalOuAppreciation, (Throwable)e);
        }
    }

    private void readMutations() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> m = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileMutations);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String bezeichnung = tokenizer.nextToken();
                String kurzBezeichnung = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, kurzBezeichnung, bezeichnung, false);
                m.put(id.toString(), optionItemDTO);
            }
            mutations = m;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileMutations, (Throwable)e);
        }
    }

    private void readGenreRendement() {
        try {
            String line;
            LinkedHashMap<String, OptionItemDTO> m = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileGenreRendement);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String bezeichnung = tokenizer.nextToken();
                String kurzBezeichnung = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)id, kurzBezeichnung, bezeichnung, false);
                m.put(id.toString(), optionItemDTO);
            }
            genreRendement = m;
            in.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileGenreRendement, (Throwable)e);
        }
    }

    private void readValoren() {
        try {
            ArrayList<ValorDatabaseDTO> vDTOs = new ArrayList<ValorDatabaseDTO>();
            BufferedReader br = DataResourceImpl.getReader(fileValoren);
            br.readLine();
            int line = 0;
            String cur = br.readLine();
            while (cur != null && line++ < 50000) {
                ValorDatabaseDTO valorDatabaseDTO = this.extractDTO(cur);
                vDTOs.add(valorDatabaseDTO);
                cur = br.readLine();
            }
            br.close();
            this.sortValorDatabaseDTOs(vDTOs);
            valoren = new LinkedHashMap<Long, ValorDatabaseDTO>();
            for (Object e : vDTOs) {
                ValorDatabaseDTO vDTO = (ValorDatabaseDTO)e;
                if (!vDTO.getAnwendbar().booleanValue() || valoren.containsKey(vDTO.getNummer())) {
                    vDTO = DataResourceImpl.getValueLessValorDatabaseDTO(vDTO);
                }
                valoren.put(vDTO.getNummer(), vDTO);
            }
        }
        catch (Exception e) {
            LOG.error(ERROR_READING_FILE + fileValoren, (Throwable)e);
        }
    }

    private void sortValorDatabaseDTOs(List<ValorDatabaseDTO> vDTOs) {
        Collections.sort(vDTOs, new Comparator<ValorDatabaseDTO>(){

            @Override
            public int compare(ValorDatabaseDTO left, ValorDatabaseDTO right) {
                return left.getBezeichnung().compareToIgnoreCase(right.getBezeichnung());
            }
        });
    }

    private Map<String, BigDecimal> readModelConfig(@NonNull String filename) {
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>();
        try {
            String line;
            BufferedReader br = DataResourceImpl.getReader(filename);
            while ((line = br.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, EQUALS);
                String key = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                BigDecimal numVal = new BigDecimal(value);
                result.put(key, numVal);
            }
            br.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + filename, (Throwable)e);
        }
        return result;
    }

    private void readBaremeImpotBenefice() {
        baremeImpotBenefice = this.readBaremeImpot(fileBaremeImpotBenefice);
    }

    private void readBaremeImpotCapital() {
        baremeImpotCapital = this.readBaremeImpot(fileBaremeImpotCapital);
    }

    private Map<Double, BaremeImpotDTO> readBaremeImpot(@NonNull String filename) {
        LinkedHashMap<Double, BaremeImpotDTO> result = new LinkedHashMap<Double, BaremeImpotDTO>();
        try {
            String line;
            BufferedReader br = DataResourceImpl.getReader(filename);
            while ((line = br.readLine()) != null) {
                if (line.startsWith(COMMENT) || line.indexOf(59) == -1) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, String.valueOf(';'));
                double startTranche = Double.parseDouble(tokenizer.nextToken());
                String endTrancheString = tokenizer.nextToken();
                double endTranche = endTrancheString.trim().length() == 0 ? 9.223372036854776E18 : Double.parseDouble(endTrancheString);
                double taux = Double.parseDouble(tokenizer.nextToken());
                double maxTranche = Double.parseDouble(tokenizer.nextToken());
                double impot = Double.parseDouble(tokenizer.nextToken());
                BaremeImpotDTO dto = new BaremeImpotDTO(startTranche, endTranche, taux, maxTranche, impot);
                result.put(startTranche, dto);
            }
            br.close();
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + filename, (Throwable)e);
        }
        return result;
    }

    private void readBarcode(String code) {
        String filename = fileDir + code + TXT;
        try {
            String line;
            barcode = new LinkedHashMap<String, Object>();
            LinkedList<String> barcodeLines = new LinkedList<String>();
            BufferedReader in = DataResourceImpl.getReader(filename);
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                barcodeLines.add(line);
            }
            in.close();
            barcode.put(BARCODE, barcodeLines);
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + filename, (Throwable)e);
        }
    }

    private @NonNull LinkedHashMap<Date, Double> readExchangeRates(String monnaie) {
        LinkedHashMap<Date, Double> result = new LinkedHashMap<Date, Double>();
        String[] resFiles = new String[]{FILE_EXCHANGE_RATES, FILE_EXCHANGE_RATES_YEAR_MINUS_1, FILE_EXCHANGE_RATES_YEAR_MINUS_2};
        int fileIndex = 0;
        try {
            for (fileIndex = 0; fileIndex < resFiles.length; ++fileIndex) {
                BufferedReader in = DataResourceImpl.getReader(resFiles[fileIndex]);
                ArrayList<String> header = new ArrayList<String>(Arrays.asList(in.readLine().split(";")));
                int columnIndex = header.indexOf(monnaie);
                if (columnIndex > 0) {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] record = line.split(";");
                        if (record.length <= columnIndex) continue;
                        result.put(this.asDate(record[0]), this.asDouble(record[columnIndex]));
                    }
                }
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.error(ERROR_READING_FILE + resFiles[fileIndex], (Throwable)ioe);
        }
        catch (ParseException pe) {
            LOG.error(ERROR_PARSING_FILE + resFiles[fileIndex], (Throwable)pe);
        }
        return result;
    }

    private static ValorDatabaseDTO getValueLessValorDatabaseDTO(@NonNull ValorDatabaseDTO template) {
        ValorDatabaseDTO result = new ValorDatabaseDTO();
        result.setNummer(template.getNummer());
        result.setType(template.getType());
        result.setBezeichnung(template.getBezeichnung());
        result.setWaehrungscode(template.getWaehrungscode());
        return result;
    }

    private ValorDatabaseDTO extractDTO(@NonNull String line) throws ParseException {
        ValorDatabaseDTO result = new ValorDatabaseDTO();
        String[] props = this.getStringsBetweenTabs(line);
        if (props.length > 0) {
            result.setNummer(this.asLong(props[0]));
        }
        if (props.length > 1) {
            result.setType(this.asInteger(props[1]));
        }
        if (props.length > 2) {
            result.setBezeichnung(this.asString(props[2]));
        }
        if (props.length > 3) {
            result.setSteuerwert(this.asDouble(props[3]));
        }
        if (props.length > 4) {
            result.setZins(this.asDouble(props[4]));
        }
        if (props.length > 5) {
            result.setWaehrungscode(this.asString(props[5]));
        }
        if (props.length > 6) {
            result.setEmissionsjahr(this.asInteger(props[6]));
        }
        if (props.length > 7) {
            result.setRueckzahlung(this.asDate(props[7]));
        }
        if (props.length > 8) {
            result.setTermin(this.asDate(props[8]));
        }
        if (props.length > 9) {
            result.setErtrag(this.asDouble(props[9]));
        }
        if (props.length > 10) {
            result.setSicavb(Boolean.valueOf(props[10]));
        }
        if (props.length > 11) {
            result.setAnwendbar(Boolean.valueOf(props[11]));
        }
        if (props.length > 12) {
            result.setVstUnterliegend(Boolean.valueOf(props[12]));
        }
        return result;
    }

    private Map<String, Map<String, OptionItemDTO>> readLocalizedFile(@NonNull String code) {
        HashMap<String, Map<String, OptionItemDTO>> result = new HashMap<String, Map<String, OptionItemDTO>>();
        try {
            String value;
            String key;
            StringTokenizer tokenizer;
            String line;
            BufferedReader in = DataResourceImpl.getReader(fileDir + code + "_de.txt");
            LinkedHashMap<String, OptionItemDTO> properties = new LinkedHashMap<String, OptionItemDTO>();
            while ((line = in.readLine()) != null) {
                if (line.startsWith(COMMENT)) continue;
                tokenizer = new StringTokenizer(line, fileDelimiter);
                key = tokenizer.nextToken();
                value = tokenizer.nextToken();
                properties.put(key, new OptionItemDTO((Object)key, null, value, false));
                result.put("de", properties);
            }
            properties = new LinkedHashMap();
            in = DataResourceImpl.getReader(fileDir + code + "_fr.txt");
            line = in.readLine();
            while (line != null) {
                if (!line.startsWith(COMMENT)) {
                    tokenizer = new StringTokenizer(line, fileDelimiter);
                    key = tokenizer.nextToken();
                    value = tokenizer.nextToken();
                    properties.put(key, new OptionItemDTO((Object)key, null, value, false));
                }
                result.put("fr", properties);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            LOG.error(ERROR_READING_FILE + fileDir + code, (Throwable)e);
        }
        return result;
    }

    private String[] getStringsBetweenTabs(@NonNull String line) {
        ArrayList<String> result = new ArrayList<String>();
        int begin = 0;
        int end = line.indexOf(9);
        while (end >= 0) {
            result.add(line.substring(begin, end));
            begin = ++end;
            end = line.indexOf(9, begin);
        }
        result.add(line.substring(begin));
        return result.toArray(new String[result.size()]);
    }

    private Integer asInteger(@NonNull String prop) {
        Integer result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = Integer.valueOf(s);
        }
        return result;
    }

    private Long asLong(@NonNull String prop) {
        Long result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = Long.valueOf(s);
        }
        return result;
    }

    private Double asDouble(@NonNull String prop) {
        Double result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = Double.valueOf(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date asDate(@NonNull String prop) throws ParseException {
        Date result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            SimpleDateFormat simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                result = SDF.parse(s);
            }
        }
        return result;
    }

    private String asString(@NonNull String prop) {
        return this.formatPropertyString(prop);
    }

    private String formatPropertyString(@Nullable String prop) {
        if (prop == null) {
            return "";
        }
        String s = prop.trim();
        if (s.length() > 1 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s.trim();
    }

    private static BufferedReader getReader(@NonNull String fileName) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fileName));
        InputStreamReader isr = new InputStreamReader((InputStream)fis, ENCODING);
        return new BufferedReader(isr);
    }

    static {
        SDF.setTimeZone(ApplicationConfig.TIMEZONE);
        fileContents = new HashMap<String, Map<String, OptionItemDTO>>();
        exchangeRates = new LinkedHashMap<String, ExchangeRatesDTO>();
        fileDir = (String)(System.getProperty("project.base.dir") != null ? System.getProperty("project.base.dir") + "/" : "") + "config/cd/resources/";
        fileConstants = fileDir + "constants.txt";
        fileValoren = fileDir + "valoren.txt";
        fileMutations = fileDir + "mutations.txt";
        fileGenreRendement = fileDir + "genreRendement.txt";
        fileCommunesCantonsPaysChoix = fileDir + "communesCantonsPaysChoix.txt";
        fileCommunesCantonsPays = fileDir + "communesCantonsPays.txt";
        fileMonnaies = fileDir + "monnaies.txt";
        fileActifsSiegeOuLocalises = fileDir + "actifsSiegeOuLocalises.txt";
        fileActifsMobiles = fileDir + "actifsMobiles.txt";
        fileCapitalDotation = fileDir + "capitalDotation.txt";
        fileSelonTotalOuAppreciation = fileDir + "selonTotalOuAppreciation.txt";
        fileTauxAnnexeG = fileDir + "tauxAnnexeG.txt";
        fileTauxCapitalisationAnnexeF = fileDir + "tauxCapitalisation.txt";
        fileTauxAnnexeGYearMinus1 = fileDir + "tauxAnnexeGYearMinus1.txt";
        fileTauxAnnexeGYearMinus2 = fileDir + "tauxAnnexeGYearMinus2.txt";
        fileTaux = fileDir + "taux.txt";
        fileBaremeImpotBenefice = fileDir + "baremeImpotBenefice.txt";
        fileBaremeImpotCapital = fileDir + "baremeImpotCapital.txt";
        FILE_EXCHANGE_RATES = fileDir + "exchangeRates.txt";
        FILE_QUANTITY_CURRENCY = fileDir + "quantite-monnaies.txt";
        FILE_EXCHANGE_RATES_YEAR_MINUS_1 = fileDir + "exchangeRatesYearMinus1.txt";
        FILE_EXCHANGE_RATES_YEAR_MINUS_2 = fileDir + "exchangeRatesYearMinus2.txt";
    }
}

