/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.justificatifs;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.CustomPrinterDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocument;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocumentsByCategory;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RequiredDocumentsPrinter
extends ExpertItemPrinter<CustomPrinterDTO> {
    private static final Font HEADER_FONT = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
    private static final Font LIST_FONT = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0);
    private static final float DEFAULT_LEADING = 16.0f;
    private static final float HEADER_LEADING = 25.0f;
    private Map<String, LogicModelItem> logicModel = null;
    private LogicModelItem.ProtectedMap dataModel = null;

    protected void initalize(CustomPrinterDTO item) {
        this.dataModel = item.getDataModel();
        this.logicModel = item.getLogicModel();
    }

    protected void printInternal(float xOffset, float yOffset) throws FormRendererException {
        assert (this.dataModel != null && this.logicModel != null);
        List<RequiredDocumentsByCategory> resolvedCategories = RequiredDocumentsByCategory.resolveAll((Map<String, ModelItemDTO>)this.dataModel, this.logicModel);
        if (!resolvedCategories.isEmpty()) {
            try {
                this.printDocument(resolvedCategories, xOffset, yOffset);
            }
            catch (LocalizationHelper.LocalizationHelperException | DocumentException e) {
                throw new FormRendererException("Failed to print list", e);
            }
        }
    }

    private void printDocument(List<RequiredDocumentsByCategory> resolvedCategories, float xOffset, float yOffset) throws DocumentException, LocalizationHelper.LocalizationHelperException {
        assert (resolvedCategories != null && !resolvedCategories.isEmpty());
        int x = 50;
        int y = 100;
        int bottomMargin = 80;
        int extraPageY = 30;
        Document doc = this.getDocumentContext().getDocument();
        Rectangle pageSize = doc.getPageSize();
        float bulletIndent = 10.0f;
        float llx = 50.0f + xOffset;
        float lly = 80.0f + yOffset;
        float urx = pageSize.getWidth() - 50.0f;
        float ury = pageSize.getHeight() - 100.0f;
        float extraPageUry = pageSize.getHeight() - 30.0f;
        float[] pageColumn = new float[]{llx, lly, urx, ury};
        float[] bulletColum = new float[]{llx, lly, llx + 10.0f};
        float[] textColumn = new float[]{llx + 10.0f, lly, urx};
        ColumnText ct = new ColumnText(this.getDirectContent());
        ct.setLeading(16.0f);
        ct.setSimpleColumn(pageColumn[0], pageColumn[1], pageColumn[2], pageColumn[3]);
        for (RequiredDocumentsByCategory requiredDocumentsByCategory : resolvedCategories) {
            Iterator<RequiredDocument> itr = requiredDocumentsByCategory.getDocs().iterator();
            Object categoryHeader = requiredDocumentsByCategory.getLabel();
            if (requiredDocumentsByCategory.getLevel() > 0) {
                categoryHeader = "   > " + (String)categoryHeader;
            }
            Paragraph header = new Paragraph(115.0f, (String)categoryHeader, HEADER_FONT);
            Chunk bullet = new Chunk("\u2022", LIST_FONT);
            Chunk firstEntry = itr.hasNext() ? new Chunk(itr.next().getLabel(), LIST_FONT) : new Chunk("");
            float yLine = ct.getYLine();
            ct.setLeading(25.0f);
            ct.addText((Phrase)header);
            boolean pageBreak = false;
            if (ColumnText.hasMoreText((int)ct.go(true))) {
                ct.setLeading(16.0f);
                pageBreak = true;
            } else {
                ct.setLeading(16.0f);
                float entryYLine = ct.getYLine();
                ct.setSimpleColumn(bulletColum[0], bulletColum[1], bulletColum[2], entryYLine);
                ct.addText(bullet);
                ct.go(true);
                ct.setSimpleColumn(textColumn[0], textColumn[1], textColumn[2], entryYLine);
                ct.addText(firstEntry);
                if (ColumnText.hasMoreText((int)ct.go(true))) {
                    pageBreak = true;
                }
            }
            if (pageBreak) {
                doc.newPage();
                ct.setSimpleColumn(llx, lly, urx, extraPageUry);
                yLine = extraPageUry;
            } else {
                ct.setSimpleColumn(pageColumn[0], pageColumn[1], pageColumn[2], yLine);
            }
            ct.setYLine(yLine);
            this.printElements(doc, pageColumn, bulletColum, textColumn, extraPageUry, ct, (String)categoryHeader, itr, (Phrase)header, bullet, firstEntry);
        }
    }

    private void printElements(Document doc, float[] pageColumn, float[] bulletColumn, float[] textColumn, float extraPageUry, ColumnText ct, String categoryHeader, Iterator<RequiredDocument> itr, Phrase header, Chunk bullet, Chunk firstEntry) throws DocumentException {
        ct.setLeading(25.0f);
        ct.setText(header);
        ct.go();
        ct.setLeading(16.0f);
        float entryYLine = ct.getYLine();
        ct.setSimpleColumn(bulletColumn[0], bulletColumn[1], bulletColumn[2], entryYLine);
        ct.addText(bullet);
        ct.go();
        ct.setSimpleColumn(textColumn[0], textColumn[1], textColumn[2], entryYLine);
        ct.addText(firstEntry);
        ct.go();
        while (itr.hasNext()) {
            float yLine = ct.getYLine();
            Chunk entry = new Chunk(itr.next().getLabel(), LIST_FONT);
            ct.addText(entry);
            if (ColumnText.hasMoreText((int)ct.go(true))) {
                doc.newPage();
                ct.setSimpleColumn(pageColumn[0], pageColumn[1], pageColumn[2], extraPageUry);
                ct.setYLine(extraPageUry);
                ct.setText(new Phrase(categoryHeader + " (suite)", HEADER_FONT));
                ct.go();
            } else {
                ct.setYLine(yLine);
            }
            entryYLine = ct.getYLine();
            ct.setSimpleColumn(bulletColumn[0], bulletColumn[1], bulletColumn[2], entryYLine);
            ct.addText(bullet);
            ct.go();
            ct.setSimpleColumn(textColumn[0], textColumn[1], textColumn[2], entryYLine);
            ct.addText(entry);
            ct.go();
        }
    }
}

