/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.justificatifs;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pm.justificatifs.Category;
import ch.dvbern.tax.ge.pm.justificatifs.CategoryTreeEntry;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocument;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocumentType;
import ch.dvbern.tax.ge.pm.utils.SharedUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequiredDocumentsByCategory {
    private static final char KEY_SEP = '.';
    private static final Pattern KEY_SEP_PTN = Pattern.compile(Pattern.quote(String.valueOf('.')));
    public static final int ROOT_LEVEL = 0;
    @Nonnull
    private final String label;
    @Nonnull
    private final Category category;
    private final int level;
    @Nonnull
    private final Set<RequiredDocument> docs;

    public RequiredDocumentsByCategory(@Nonnull String label, @Nonnull Category category, int level, Set<RequiredDocument> docs) {
        assert (label != null && category != null && docs != null);
        assert (level >= 0);
        this.label = label;
        this.category = category;
        this.level = level;
        this.docs = Collections.unmodifiableSet(docs);
    }

    public static List<RequiredDocumentsByCategory> resolveAll(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel) {
        if (dataModel == null) {
            throw new NullPointerException("Data model cannot be null.");
        }
        if (logicModel == null) {
            throw new NullPointerException("Logic model cannot be null.");
        }
        Set<CategoryTreeEntry> categoryTree = CategoryTreeEntry.getCategoryTree();
        return RequiredDocumentsByCategory.resolveChildren(dataModel, logicModel, 0, categoryTree);
    }

    @Nonnull
    private static List<RequiredDocumentsByCategory> resolveChildren(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, int level, @Nonnull Set<CategoryTreeEntry> categoryTree) {
        ArrayList<RequiredDocumentsByCategory> categories = new ArrayList<RequiredDocumentsByCategory>();
        for (CategoryTreeEntry entry : categoryTree) {
            Category category = entry.getCategory();
            String[] categoryAddOnLmks = category.getAddOnsLmk();
            Set<RequiredDocumentType> requiredDocumentTypes = entry.getRequiredDocumentTypes();
            RequiredDocumentsByCategory requiredDocumentsByCategory = null;
            if (categoryAddOnLmks.length > 0) {
                categories.addAll(RequiredDocumentsByCategory.buildDynamicCategories(dataModel, logicModel, category, level, requiredDocumentTypes, categoryAddOnLmks));
            } else {
                requiredDocumentsByCategory = RequiredDocumentsByCategory.buildSimpleCategory(dataModel, logicModel, category, level, requiredDocumentTypes);
            }
            List<RequiredDocumentsByCategory> childCategories = RequiredDocumentsByCategory.resolveChildren(dataModel, logicModel, level + 1, entry.getChildren());
            if (!childCategories.isEmpty() || requiredDocumentsByCategory != null && !requiredDocumentsByCategory.getDocs().isEmpty()) {
                categories.add(requiredDocumentsByCategory);
            }
            categories.addAll(childCategories);
        }
        return categories;
    }

    @Nonnull
    private static RequiredDocumentsByCategory buildSimpleCategory(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull Category category, int level, @Nonnull Set<RequiredDocumentType> requiredDocumentTypes) throws LocalizationHelper.LocalizationHelperException {
        LinkedHashSet<RequiredDocument> docs = new LinkedHashSet<RequiredDocument>();
        for (RequiredDocumentType requiredDocumentType : requiredDocumentTypes) {
            List<String> stateDmks = RequiredDocumentsByCategory.getAllDmksFromLmk(dataModel, logicModel, requiredDocumentType.getStateLmk());
            RequiredDocumentsByCategory.buildDocs(dataModel, requiredDocumentType, stateDmks, docs);
        }
        return new RequiredDocumentsByCategory(SharedUtils.translate(category.getKey(), new Object[0]), category, level, docs);
    }

    @Nonnull
    private static List<RequiredDocumentsByCategory> buildDynamicCategories(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull Category category, int level, @Nonnull Set<RequiredDocumentType> requiredDocumentTypes, @Nonnull String[] categoryAddOnLmks) throws LocalizationHelper.LocalizationHelperException {
        assert (logicModel != null && dataModel != null && category != null && requiredDocumentTypes != null && categoryAddOnLmks != null);
        assert (categoryAddOnLmks.length > 0);
        ArrayList<RequiredDocumentsByCategory> categories = new ArrayList<RequiredDocumentsByCategory>();
        String categoryMainAddOnLmk = categoryAddOnLmks[0];
        for (String categoryMainAddOnDmk : RequiredDocumentsByCategory.getAllDmksFromLmk(dataModel, logicModel, categoryMainAddOnLmk)) {
            LinkedHashSet<RequiredDocument> docs = new LinkedHashSet<RequiredDocument>();
            Object[] categoryAddOns = new Object[categoryAddOnLmks.length];
            categoryAddOns[0] = RequiredDocumentsByCategory.getAddOnValue(dataModel, categoryMainAddOnDmk);
            for (int i = 1; i < categoryAddOnLmks.length; ++i) {
                String categoryAddOnLmk = categoryAddOnLmks[i];
                categoryAddOns[i] = RequiredDocumentsByCategory.getAddOnValue(dataModel, categoryAddOnLmk, categoryMainAddOnDmk);
            }
            for (RequiredDocumentType requiredDocumentType : requiredDocumentTypes) {
                String baseLmk = RequiredDocumentsByCategory.commonBaseLmk(categoryMainAddOnLmk, requiredDocumentType.getStateLmk());
                List<String> stateDmks = RequiredDocumentsByCategory.getAllDmksFromLmk(dataModel, logicModel, new StringBuilder(EngineUtil.mergeModelKey((String)baseLmk, (String)categoryMainAddOnDmk)), new StringBuilder(baseLmk), requiredDocumentType.getStateLmk().substring(baseLmk.length()));
                RequiredDocumentsByCategory.buildDocs(dataModel, requiredDocumentType, stateDmks, docs);
            }
            if (docs.isEmpty()) continue;
            categories.add(new RequiredDocumentsByCategory(SharedUtils.translate(category.getKey(), categoryAddOns), category, level, docs));
        }
        return categories;
    }

    @Nonnull
    private static String commonBaseLmk(@Nonnull String lmkA, @Nonnull String lmkB) {
        assert (lmkA != null && lmkB != null);
        int lastSep = 0;
        int minLength = Math.min(lmkA.length(), lmkB.length());
        for (int i = 0; i < minLength; ++i) {
            char c = lmkA.charAt(i);
            if (c != lmkB.charAt(i)) {
                return lmkA.substring(0, lastSep);
            }
            if (c != '.') continue;
            lastSep = i;
        }
        return lmkA.substring(0, minLength);
    }

    private static void buildDocs(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull RequiredDocumentType requiredDocumentType, @Nonnull List<String> stateDmks, @Nonnull Collection<? super RequiredDocument> docs) throws LocalizationHelper.LocalizationHelperException {
        for (String stateDmk : stateDmks) {
            RequiredDocument doc;
            ModelItemDTO stateItem = dataModel.get(stateDmk);
            if (stateItem == null || stateItem.getState() == 12 || stateItem.getState() == 11 || (doc = RequiredDocumentsByCategory.buildDoc(dataModel, requiredDocumentType, stateDmk)) == null) continue;
            docs.add(doc);
        }
    }

    @Nullable
    private static RequiredDocument buildDoc(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull RequiredDocumentType requiredDocumentType, @Nonnull String stateDmk) throws LocalizationHelper.LocalizationHelperException {
        assert (dataModel != null && requiredDocumentType != null && stateDmk != null);
        String[] addOnLmks = requiredDocumentType.getAddOnLmks();
        Object[] addOns = new Object[addOnLmks.length];
        for (int i = 0; i < addOnLmks.length; ++i) {
            addOns[i] = RequiredDocumentsByCategory.getAddOnValue(dataModel, addOnLmks[i], stateDmk);
        }
        String labelKey = null;
        if (requiredDocumentType.isGetLabelFromModel()) {
            Object labelObj;
            ModelItemDTO labelItem = dataModel.get(EngineUtil.mergeModelKey((String)requiredDocumentType.getLabel(), (String)stateDmk));
            if (labelItem != null && (labelObj = labelItem.getValue()) != null) {
                labelKey = labelObj.toString();
            }
        } else {
            labelKey = requiredDocumentType.getLabel();
        }
        return labelKey == null ? null : new RequiredDocument(requiredDocumentType, SharedUtils.translate(labelKey, addOns));
    }

    @Nonnull
    private static Object getAddOnValue(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull String lmk, @Nonnull String contextDmk) {
        assert (dataModel != null && lmk != null && contextDmk != null);
        return RequiredDocumentsByCategory.getAddOnValue(dataModel, EngineUtil.mergeModelKey((String)lmk, (String)contextDmk));
    }

    @Nonnull
    private static Object getAddOnValue(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull String dmk) {
        Object value;
        assert (dataModel != null && dmk != null);
        ModelItemDTO item = dataModel.get(dmk);
        Object object = value = item != null ? item.getValue() : "";
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Nonnull
    private static List<String> getAllDmksFromLmk(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull String lmk) {
        return RequiredDocumentsByCategory.getAllDmksFromLmk(dataModel, logicModel, new StringBuilder(), new StringBuilder(), lmk);
    }

    @Nonnull
    private static List<String> getAllDmksFromLmk(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull StringBuilder dmkBuilder, @Nonnull StringBuilder lmkBuilder, String lmk) {
        assert (dataModel != null && logicModel != null && lmk != null);
        Scanner lmkScanner = new Scanner(lmk);
        lmkScanner.useDelimiter(KEY_SEP_PTN);
        int startPos = lmkBuilder.length();
        while (lmkScanner.hasNext()) {
            String lmkToken = lmkScanner.next();
            RequiredDocumentsByCategory.addToken(lmkBuilder, lmkToken);
            LogicModelItem lmi = logicModel.get(lmkBuilder.toString());
            if (lmi == null) {
                lmkScanner.close();
                throw new IllegalArgumentException("Cannot retrieve intermediate node " + lmkToken + " in LMK " + lmkBuilder);
            }
            RequiredDocumentsByCategory.addToken(dmkBuilder, lmkToken);
            if (!(lmi instanceof Table)) continue;
            lmkScanner.close();
            String tableDmk = dmkBuilder.toString();
            ModelItemDTO tableItem = dataModel.get(tableDmk);
            if (tableItem == null) {
                return Collections.emptyList();
            }
            Object indexesObj = tableItem.getValue();
            if (indexesObj == null) {
                return Collections.emptyList();
            }
            if (!(indexesObj instanceof Set)) {
                assert (false);
                return Collections.emptyList();
            }
            ArrayList indexes = new ArrayList((Set)indexesObj);
            Collections.sort(indexes);
            ArrayList<String> result = new ArrayList<String>();
            int dmkMark = dmkBuilder.length();
            int lmkMark = lmkBuilder.length();
            String remainingLmk = lmk.substring(lmkBuilder.length() - startPos);
            for (String index : indexes) {
                RequiredDocumentsByCategory.addToken(dmkBuilder, index);
                result.addAll(RequiredDocumentsByCategory.getAllDmksFromLmk(dataModel, logicModel, dmkBuilder, lmkBuilder, remainingLmk));
                dmkBuilder.setLength(dmkMark);
                lmkBuilder.setLength(lmkMark);
            }
            return result;
        }
        return Collections.singletonList(dmkBuilder.toString());
    }

    private static void addToken(@Nonnull StringBuilder sb, @Nonnull String token) {
        assert (sb != null && token != null);
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(token);
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public Category getCategory() {
        return this.category;
    }

    public int getLevel() {
        return this.level;
    }

    @Nonnull
    public Set<RequiredDocument> getDocs() {
        return this.docs;
    }
}

