/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.justificatifs;

import ch.dvbern.tax.ge.pm.justificatifs.Category;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocumentType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CategoryTreeEntry
implements Serializable {
    private static final long serialVersionUID = 6051526585911044435L;
    @Nonnull
    private final Category category;
    @Nonnull
    private final Set<CategoryTreeEntry> children;
    @Nonnull
    private final Set<RequiredDocumentType> requiredDocumentTypes;
    @Nonnull
    private static final Set<CategoryTreeEntry> ROOT;

    @Nonnull
    private static LinkedHashSet<RequiredDocumentType> findJustificatifs(@Nonnull Category category) {
        LinkedHashSet<RequiredDocumentType> requiredDocumentTypes = new LinkedHashSet<RequiredDocumentType>();
        for (RequiredDocumentType requiredDocumentType : RequiredDocumentType.values()) {
            if (requiredDocumentType.getCategory() != category) continue;
            requiredDocumentTypes.add(requiredDocumentType);
        }
        return requiredDocumentTypes;
    }

    private CategoryTreeEntry(@Nonnull Category category, CategoryTreeEntry ... children) {
        this.category = category;
        LinkedHashSet<CategoryTreeEntry> c = new LinkedHashSet<CategoryTreeEntry>();
        c.addAll(Arrays.asList(children));
        this.children = c;
        this.requiredDocumentTypes = Collections.unmodifiableSet(CategoryTreeEntry.findJustificatifs(category));
    }

    @Nonnull
    public static Set<CategoryTreeEntry> getCategoryTree() {
        return ROOT;
    }

    @Nonnull
    public Category getCategory() {
        return this.category;
    }

    @Nonnull
    public Set<CategoryTreeEntry> getChildren() {
        return this.children;
    }

    @Nonnull
    public Set<RequiredDocumentType> getRequiredDocumentTypes() {
        return this.requiredDocumentTypes;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryTreeEntry)) {
            return false;
        }
        CategoryTreeEntry that = (CategoryTreeEntry)o;
        return this.category == that.category;
    }

    public int hashCode() {
        return this.category.hashCode();
    }

    static {
        LinkedHashSet<CategoryTreeEntry> rootCategories = new LinkedHashSet<CategoryTreeEntry>();
        rootCategories.add(new CategoryTreeEntry(Category.JUSTIFICATIFS_REQUIS, new CategoryTreeEntry[0]));
        ROOT = Collections.unmodifiableSet(rootCategories);
    }
}

