/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.envoi;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.ge.pm.envoi.CryptFileFormat;
import ch.dvbern.tax.ge.pm.envoi.CryptSessionKey;
import ch.dvbern.tax.ge.pm.envoi.GeEnvoiConfiguration;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeCryptFileFormatV1
extends CryptFileFormat<GeCryptFileContext> {
    private static final Logger LOG = LoggerFactory.getLogger(GeCryptFileFormatV1.class);
    private static final int INITIAL_BYTE_BUFFER_SIZE = 0x100000;
    private static final String FILE_FORMAT_VERSION = "V1";
    static final byte[] MAGIC_BYTES;
    private static SecureRandom random;
    private static GeCryptFileFormatV1 instance;

    private GeCryptFileFormatV1() {
    }

    public static GeCryptFileFormatV1 getInstance() {
        return instance;
    }

    private static PublicKey loadTaxfileRemotePublicKey() throws GeneralSecurityException {
        File taxfileRemotePublicKeyFile = GeEnvoiConfiguration.getEncryptionPubkeyFile();
        try {
            byte[] pkBytes = FileUtils.readFileToByteArray((File)taxfileRemotePublicKeyFile);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pkBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
            return publicKey;
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Developer error: could not load remote public key", e);
        }
    }

    @Override
    protected Cipher getDataEncryptionCipher(GeCryptFileContext ctx, CryptSessionKey sessionKey) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, sessionKey.getSessionKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            LOG.error("Error building the cipher used for encrypting", (Throwable)e);
        }
        return cipher;
    }

    @Override
    protected CryptSessionKey getSessionEncryptionKey(GeCryptFileContext ctx) throws CryptFileFormat.CryptFileException {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128, random);
            SecretKey sessionKey = keyGen.generateKey();
            PublicKey pk = GeCryptFileFormatV1.loadTaxfileRemotePublicKey();
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pk);
            byte[] encryptedSessionId = cipher.doFinal(sessionKey.getEncoded());
            CryptSessionKey cryptedId = new CryptSessionKey(sessionKey, encryptedSessionId);
            return cryptedId;
        }
        catch (Exception e) {
            throw new CryptFileFormat.CryptFileException("Developer error: could not create a secure session id", e);
        }
    }

    @Override
    protected void writeMagic(GeCryptFileContext ctx, OutputStream out) throws CryptFileFormat.CryptFileException {
        try {
            out.write(MAGIC_BYTES);
        }
        catch (IOException e) {
            throw new CryptFileFormat.CryptFileException(e);
        }
    }

    @Override
    protected InputStream getDataForEncryption(GeCryptFileContext ctx) {
        return new ByteArrayInputStream(ctx.getPayload());
    }

    @Override
    protected OutputStream beginOutput(GeCryptFileContext ctx) {
        return ctx.getTempBaos();
    }

    @Override
    protected void endOutput(GeCryptFileContext ctx, boolean errorOccured) throws CryptFileFormat.CryptFileException {
        if (errorOccured) {
            return;
        }
        BufferedOutputStream outStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(ctx.getOutputFile()));
            IOUtils.copy((InputStream)new ByteArrayInputStream(ctx.getTempBaos().toByteArray()), (OutputStream)outStream);
            ((OutputStream)outStream).close();
        }
        catch (IOException e) {
            try {
                throw new CryptFileFormat.CryptFileException(Messages.translate((String)"error.upload.cannotwritefile", (Object[])new String[]{e.getLocalizedMessage()}), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outStream);
    }

    static {
        try {
            MAGIC_BYTES = "GECRYPTAXV1".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error initializing magic Bytes", e);
        }
        random = new SecureRandom(Long.valueOf(new Date().getTime()).toString().getBytes());
        instance = new GeCryptFileFormatV1();
    }

    public static class GeCryptFileContext
    implements CryptFileFormat.CryptFileContext {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
        private final File outputFile;
        private final byte[] payload;

        public GeCryptFileContext(File outputFile, byte[] payload) {
            this.outputFile = outputFile;
            this.payload = (byte[])payload.clone();
        }

        public ByteArrayOutputStream getTempBaos() {
            return this.baos;
        }

        public File getOutputFile() {
            return this.outputFile;
        }

        public byte[] getPayload() {
            return this.payload;
        }
    }
}

