/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.envoi;

import ch.dvbern.tax.ge.pm.envoi.CryptSessionKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.apache.commons.io.IOUtils;

public abstract class CryptFileFormat<Context extends CryptFileContext> {
    private static final byte[] DEFAULT_FIELD_SEPARATOR = new byte[]{0};
    private final byte[] fieldSeparator;

    public CryptFileFormat(byte[] fieldSeparator) {
        this.fieldSeparator = (byte[])fieldSeparator.clone();
    }

    public CryptFileFormat() {
        this(DEFAULT_FIELD_SEPARATOR);
    }

    protected byte[] getFieldSeparator(Context ctx) {
        return this.fieldSeparator;
    }

    protected abstract CryptSessionKey getSessionEncryptionKey(Context var1) throws CryptFileException;

    protected abstract Cipher getDataEncryptionCipher(Context var1, CryptSessionKey var2);

    protected abstract OutputStream beginOutput(Context var1);

    protected abstract void endOutput(Context var1, boolean var2) throws CryptFileException;

    protected abstract void writeMagic(Context var1, OutputStream var2) throws CryptFileException;

    protected abstract InputStream getDataForEncryption(Context var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(Context ctx) throws CryptFileException {
        CryptSessionKey sessionKey = this.getSessionEncryptionKey(ctx);
        Cipher dataCipher = this.getDataEncryptionCipher(ctx, sessionKey);
        byte[] separator = this.getFieldSeparator(ctx);
        OutputStream out = null;
        try {
            out = this.beginOutput(ctx);
            this.writeMagic(ctx, out);
            out.write(separator);
            out.flush();
            out.write(sessionKey.getEncryptedKey());
            out.write(separator);
            out.flush();
            CipherOutputStream cipherOut = new CipherOutputStream(out, dataCipher);
            IOUtils.copy((InputStream)this.getDataForEncryption(ctx), (OutputStream)cipherOut);
            cipherOut.flush();
            cipherOut.close();
            out.flush();
            this.endOutput(ctx, false);
            out.close();
        }
        catch (IOException e) {
            this.endOutput(ctx, true);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static interface CryptFileContext {
    }

    public static class CryptFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CryptFileException() {
        }

        public CryptFileException(String message, Throwable cause) {
            super(message, cause);
        }

        public CryptFileException(String message) {
            super(message);
        }

        public CryptFileException(Throwable cause) {
            super(cause);
        }
    }
}

