/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.envoi;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.GeBarcodeGenerator;
import ch.dvbern.tax.ge.pm.envoi.GeCryptFileFormatV1;
import ch.dvbern.tax.ge.pm.envoi.GeEnvoiConfiguration;
import ch.dvbern.tax.ge.pm.envoi.ReleaseMode;
import ch.dvbern.tax.ge.pm.presentation.cd.util.GeEnvoiElectroniquePrintJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveGenerationTask
implements IRunnableWithProgress {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveGenerationTask.class);
    private final DvbTaxCdSession sessionImpl;
    private final File outputFile;
    private final String namePart;
    private final Date datePart;
    private final String noContribuablePart;
    private static final int WORK_PREPARE = 10;
    private static final int WORK_DECLARATION = 10;
    private static final int WORK_BARCODE = 10;

    private String getPartName() {
        ModelItemDTO nameItem = (ModelItemDTO)this.sessionImpl.getDataModel().get("Declaration_af.Form1_af.RaisonSociale");
        if (nameItem == null || nameItem.getValue() == null) {
            nameItem = (ModelItemDTO)this.sessionImpl.getDataModel().get("Declaration.Form1.RaisonSociale");
        }
        if (nameItem == null) {
            LOG.warn("Developer Error: RaisonSociale not found");
        }
        return String.valueOf(nameItem.getValue());
    }

    private String getPartNoContribuable() {
        ModelItemDTO noContribuableItem = (ModelItemDTO)this.sessionImpl.getDataModel().get("Declaration_af.Form1_af.NumeroContribuable");
        if (noContribuableItem == null || noContribuableItem.getValue() == null) {
            noContribuableItem = (ModelItemDTO)this.sessionImpl.getDataModel().get("Declaration.Form1.NumeroContribuable");
        }
        if (noContribuableItem == null) {
            LOG.warn("Developer Error: NumeroContribuable not found");
        }
        return String.valueOf(noContribuableItem.getValue());
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public ArchiveGenerationTask(DvbTaxCdSession sessionImpl) {
        this.sessionImpl = sessionImpl;
        this.namePart = this.getPartName();
        this.datePart = new Date();
        this.noContribuablePart = this.getPartNoContribuable();
        this.outputFile = new File(GeEnvoiConfiguration.getExportDir(), GeEnvoiConfiguration.getArchiveFilename(this.namePart, this.datePart, this.noContribuablePart));
    }

    private static void checkCancel(IProgressMonitor monitor) throws InterruptedException {
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException("Task aborted: " + monitor.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntries(OutputStream out, String name, Date date, String noContribuable, SubMonitor monitor) throws InterruptedException, IOException, InvocationTargetException {
        LOG.trace("ArchiveGenerationTask.run(IProgressMonitor) start");
        CheckedOutputStream crcStream = null;
        try {
            ZipOutputStream zipStream = new ZipOutputStream(out);
            CRC32 crc = new CRC32();
            CheckedOutputStream topLevelStream = crcStream = new CheckedOutputStream(zipStream, crc);
            assert (topLevelStream != null);
            ArrayList checksums = new ArrayList(3);
            ArchiveGenerationTask.checkCancel((IProgressMonitor)monitor);
            long timestamp = System.currentTimeMillis();
            this.processZipEntry((IProgressMonitor)monitor, "label.dialog.envoi.task.generationarchive.declaration", zipStream, GeEnvoiConfiguration.getArchivedDeclarationFilename(name, date, noContribuable));
            GeEnvoiElectroniquePrintJob task = new GeEnvoiElectroniquePrintJob(timestamp, (OutputStream)new CloseShieldOutputStream((OutputStream)crcStream));
            task.run((IProgressMonitor)monitor.newChild(10));
            this.processCheckedEntry(crcStream, checksums);
            ArchiveGenerationTask.checkCancel((IProgressMonitor)monitor);
            this.processZipEntry((IProgressMonitor)monitor, "label.dialog.envoi.task.generationarchive.barcode", zipStream, GeEnvoiConfiguration.getArchivedXmlBarcodeFilename(name, date, noContribuable));
            byte[] xmlBarcode = this.sessionImpl.generateBarcode((Barcode2DGenerator)new GeBarcodeGenerator(false, timestamp, ReleaseMode.PRINT, false)).getData();
            crcStream.write(xmlBarcode);
            monitor.worked(10);
            this.processCheckedEntry(crcStream, checksums);
            ArchiveGenerationTask.checkCancel((IProgressMonitor)monitor);
            ((OutputStream)topLevelStream).flush();
            ArchiveGenerationTask.checkCancel((IProgressMonitor)monitor);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(crcStream);
            LOG.trace("ArchiveGenerationTask.run(IProgressMonitor) end");
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)crcStream);
        LOG.trace("ArchiveGenerationTask.run(IProgressMonitor) end");
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)0);
        if (this.outputFile == null || this.sessionImpl == null) {
            throw new NullPointerException("Illegal null parameter: " + this.outputFile + "/" + this.sessionImpl);
        }
        try {
            this.outputFile.createNewFile();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        if (!this.outputFile.canWrite()) {
            throw new InvocationTargetException(new IOException(Messages.translate((String)"error.upload.cannotwritefile", (Object[])new Object[0])));
        }
        int totalWork = 30;
        subMonitor.beginTask(Messages.translate((String)"label.dialog.envoi.task.generationarchive", (Object[])new String[]{this.outputFile.getName()}), totalWork);
        ByteArrayOutputStream payload = null;
        try {
            subMonitor.worked(10);
            payload = new ByteArrayOutputStream(0x100000);
            this.addEntries(payload, this.namePart, this.datePart, this.noContribuablePart, subMonitor);
            payload.flush();
            GeCryptFileFormatV1.GeCryptFileContext cryptContext = new GeCryptFileFormatV1.GeCryptFileContext(this.outputFile, payload.toByteArray());
            GeCryptFileFormatV1.getInstance().writeFile(cryptContext);
        }
        catch (Exception e) {
            try {
                if (!this.outputFile.exists() || !this.outputFile.delete()) {
                    // empty if block
                }
                if (e instanceof InvocationTargetException) {
                    throw (InvocationTargetException)e;
                }
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                throw new InvocationTargetException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(payload);
                monitor.done();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)payload);
        monitor.done();
    }

    private void processCheckedEntry(CheckedOutputStream checkedStream, List<? super Long> checksums) throws IOException {
        checkedStream.flush();
        Checksum cks = checkedStream.getChecksum();
        checksums.add((Long)cks.getValue());
        cks.reset();
    }

    private void processZipEntry(IProgressMonitor monitor, String taskKey, ZipOutputStream zipStream, String entryName) throws IOException {
        monitor.subTask(Messages.translate((String)taskKey, (Object[])new Object[0]));
        zipStream.putNextEntry(new ZipEntry(entryName));
    }
}

