/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class ReductionMaximaleSelonart2LIPMValidator
implements Validator {
    private final Reference forsEtrangerReference;
    private final Reference forsSuisseReference;
    private final Reference reductionMaximaleRevendiqueReference;
    private final Reference benNetTotalCantonICC;

    public ReductionMaximaleSelonart2LIPMValidator(Reference forsEtranger, Reference forsSuisse, Reference reductionMaximaleRevendique, Reference benNetTotalCantonICC) {
        this.forsEtrangerReference = forsEtranger;
        this.forsSuisseReference = forsSuisse;
        this.reductionMaximaleRevendiqueReference = reductionMaximaleRevendique;
        this.benNetTotalCantonICC = benNetTotalCantonICC;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.forsEtrangerReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.forsSuisseReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.reductionMaximaleRevendiqueReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.benNetTotalCantonICC.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO forsEtrangerDTO = dataModel.get((Object)this.forsEtrangerReference.getName());
        ModelItemDTO forsSuisseDTO = dataModel.get((Object)this.forsSuisseReference.getName());
        ModelItemDTO reductionMaximaleRevendiqueDTO = dataModel.get((Object)this.reductionMaximaleRevendiqueReference.getName());
        ModelItemDTO benNetTotalCantonICCDTO = dataModel.get((Object)this.benNetTotalCantonICC.getName());
        boolean forsEtranger = false;
        boolean forsSuisse = false;
        boolean reductionMaximaleRevendiqueIsEmpty = true;
        long benNetTotalCantonICC = 0L;
        long benNetNonImposableVertuArretExonAnterieur2001 = 0L;
        if (forsEtrangerDTO != null && forsEtrangerDTO.getValue() != null) {
            forsEtranger = (Boolean)forsEtrangerDTO.getValue();
        }
        if (forsSuisseDTO != null && forsSuisseDTO.getValue() != null) {
            forsSuisse = (Boolean)forsSuisseDTO.getValue();
        }
        if (reductionMaximaleRevendiqueDTO != null && reductionMaximaleRevendiqueDTO.getValue() != null) {
            boolean bl = reductionMaximaleRevendiqueIsEmpty = (Long)reductionMaximaleRevendiqueDTO.getValue() == 0L;
        }
        if (benNetTotalCantonICCDTO != null && benNetTotalCantonICCDTO.getValue() != null) {
            benNetTotalCantonICC = (Long)benNetTotalCantonICCDTO.getValue();
        }
        if (forsSuisse) {
            modelItemDTO = new ModelItemDTO().clone(12);
        }
        if (!forsSuisse) {
            modelItemDTO = modelItemDTO.clone((Object)this.calculateValue(benNetTotalCantonICC, benNetNonImposableVertuArretExonAnterieur2001), 11, null);
        }
        if (!forsEtranger && !forsSuisse && reductionMaximaleRevendiqueIsEmpty) {
            modelItemDTO = new ModelItemDTO().clone(12);
        }
        return modelItemDTO;
    }

    private double calculateValue(long benNetTotalCantonICC, long benNetNonImposableVertuArretExonAnterieur2001) {
        if (benNetTotalCantonICC < 0L) {
            return 0.0;
        }
        return benNetTotalCantonICC + benNetNonImposableVertuArretExonAnterieur2001;
    }
}

