/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class ReductionMaximaleSelonart1LIPMValidator
implements Validator {
    private final Reference forsEtrangerReference;
    private final Reference forsSuisseReference;
    private final Reference reductionMaximaleRevendiqueReference;
    private final Reference resultatFiscalICC;
    private final Reference sommeRendementNetParticipations;
    private final Reference benNetImposableCHICC;
    private final Reference pertesFiscalesICC;

    public ReductionMaximaleSelonart1LIPMValidator(Reference forsEtranger, Reference forsSuisse, Reference reductionMaximaleRevendique, Reference resultatFiscalICC, Reference sommeRendementNetParticipations, Reference benNetImposableCHICC, Reference pertesFiscalesICC) {
        this.forsEtrangerReference = forsEtranger;
        this.forsSuisseReference = forsSuisse;
        this.reductionMaximaleRevendiqueReference = reductionMaximaleRevendique;
        this.resultatFiscalICC = resultatFiscalICC;
        this.sommeRendementNetParticipations = sommeRendementNetParticipations;
        this.benNetImposableCHICC = benNetImposableCHICC;
        this.pertesFiscalesICC = pertesFiscalesICC;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.forsEtrangerReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.forsSuisseReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.reductionMaximaleRevendiqueReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.resultatFiscalICC.registerListenerOnReference(logicModel, logicModelItem, false);
        this.sommeRendementNetParticipations.registerListenerOnReference(logicModel, logicModelItem, false);
        this.benNetImposableCHICC.registerListenerOnReference(logicModel, logicModelItem, false);
        this.pertesFiscalesICC.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO forsEtrangerDTO = dataModel.get((Object)this.forsEtrangerReference.getName());
        ModelItemDTO forsSuisseDTO = dataModel.get((Object)this.forsSuisseReference.getName());
        ModelItemDTO reductionMaximaleRevendiqueDTO = dataModel.get((Object)this.reductionMaximaleRevendiqueReference.getName());
        ModelItemDTO resultatFiscalICCDTO = dataModel.get((Object)this.resultatFiscalICC.getName());
        ModelItemDTO sommeRendementNetParticipationsDTO = dataModel.get((Object)this.sommeRendementNetParticipations.getName());
        ModelItemDTO benNetImposableCHICCDTO = dataModel.get((Object)this.benNetImposableCHICC.getName());
        ModelItemDTO pertesFiscalesICCDTO = dataModel.get((Object)this.pertesFiscalesICC.getName());
        boolean forsEtranger = false;
        boolean forsSuisse = false;
        long reductionMaximaleRevendique = 0L;
        long resultatFiscalICC = 0L;
        long sommeRendementNetParticipations = 0L;
        long benNetImposableCHICC = 0L;
        long pertesFiscalesICC = 0L;
        long value = 0L;
        if (forsEtrangerDTO != null && forsEtrangerDTO.getValue() != null) {
            forsEtranger = (Boolean)forsEtrangerDTO.getValue();
        }
        if (forsSuisseDTO != null && forsSuisseDTO.getValue() != null) {
            forsSuisse = (Boolean)forsSuisseDTO.getValue();
        }
        if (reductionMaximaleRevendiqueDTO != null && reductionMaximaleRevendiqueDTO.getValue() != null) {
            reductionMaximaleRevendique = (Long)reductionMaximaleRevendiqueDTO.getValue();
        }
        if (resultatFiscalICCDTO != null && resultatFiscalICCDTO.getValue() != null) {
            resultatFiscalICC = (Long)resultatFiscalICCDTO.getValue();
        }
        if (sommeRendementNetParticipationsDTO != null && sommeRendementNetParticipationsDTO.getValue() != null) {
            sommeRendementNetParticipations = (Long)sommeRendementNetParticipationsDTO.getValue();
        }
        if (benNetImposableCHICCDTO != null && benNetImposableCHICCDTO.getValue() != null) {
            benNetImposableCHICC = (Long)benNetImposableCHICCDTO.getValue();
        }
        if (pertesFiscalesICCDTO != null && pertesFiscalesICCDTO.getValue() != null) {
            pertesFiscalesICC = (Long)pertesFiscalesICCDTO.getValue();
        }
        if (modelItemDTO != null && modelItemDTO.getValue() != null && modelItemDTO.getValue() instanceof Long) {
            value = (Long)modelItemDTO.getValue();
        }
        long calcul = this.calculateValue(benNetImposableCHICC, pertesFiscalesICC, sommeRendementNetParticipations);
        if (reductionMaximaleRevendique == 0L && !forsSuisse && !forsEtranger) {
            modelItemDTO = new ModelItemDTO(null, 12);
        } else if (forsSuisse) {
            modelItemDTO = new ModelItemDTO(null, 12);
        } else if (forsEtranger) {
            boolean hasInsertHisOwnValue;
            assert (modelItemDTO != null);
            boolean bl = hasInsertHisOwnValue = modelItemDTO.getValue() != null && (double)Math.abs(value - calcul) > 0.01;
            if (hasInsertHisOwnValue) {
                modelItemDTO = value < 0L ? new ModelItemDTO().clone((Object)value, 4, "warning.decla.PG3.repartition.internationale.neg", (Object)value, 4) : new ModelItemDTO().clone((Object)value, 2, "warning.decla.PG3.repartition.internationale", (Object)value, 2);
            } else if (reductionMaximaleRevendique > 0L) {
                modelItemDTO = new ModelItemDTO().clone((Object)calcul, 2, "warning.decla.PG3.repartition.internationale", (Object)calcul, 2);
                modelItemDTO.setTouched();
            } else {
                modelItemDTO = new ModelItemDTO().clone(null, 2, "warning.decla.PG3.repartition.internationale", null, 2);
                modelItemDTO.setTouched();
            }
        } else {
            modelItemDTO = reductionMaximaleRevendique > 0L && resultatFiscalICC < 0L || resultatFiscalICC < sommeRendementNetParticipations ? new ModelItemDTO().clone(12) : new ModelItemDTO().clone((Object)calcul, 12, null);
        }
        return modelItemDTO;
    }

    private long calculateValue(long benNetImposableCHICC, long pertesFiscalesICC, long sommeRendementNetParticipations) {
        return (benNetImposableCHICC + pertesFiscalesICC - sommeRendementNetParticipations) * 9L / 100L;
    }
}

