/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class ReductionBrevetsEtRecherche
implements Validator {
    private final Reference forsSuisseReference;
    private final Reference hasAnnexeMNReference;
    private final Reference reductionBrevetsOuRecherche;

    public ReductionBrevetsEtRecherche(Reference forsSuisse, Reference hasAnnexeMN, Reference reductionBrevetsOuRecherche) {
        this.forsSuisseReference = forsSuisse;
        this.hasAnnexeMNReference = hasAnnexeMN;
        this.reductionBrevetsOuRecherche = reductionBrevetsOuRecherche;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.forsSuisseReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.hasAnnexeMNReference.registerListenerOnReference(logicModel, logicModelItem, false);
        this.reductionBrevetsOuRecherche.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO forsSuisseDTO = dataModel.get((Object)this.forsSuisseReference.getName());
        ModelItemDTO hasAnnexeMNDTO = dataModel.get((Object)this.hasAnnexeMNReference.getName());
        ModelItemDTO reductionBrevetsDTO = dataModel.get((Object)this.reductionBrevetsOuRecherche.getName());
        boolean forsSuisse = false;
        boolean hasAnnexeMN = false;
        if (forsSuisseDTO != null && forsSuisseDTO.getValue() != null) {
            forsSuisse = (Boolean)forsSuisseDTO.getValue();
        }
        if (hasAnnexeMNDTO != null && hasAnnexeMNDTO.getValue() != null) {
            hasAnnexeMN = (Boolean)hasAnnexeMNDTO.getValue();
        }
        if (!hasAnnexeMN || hasAnnexeMN && forsSuisse) {
            modelItemDTO = new ModelItemDTO().clone(12);
        } else if (hasAnnexeMN && !forsSuisse) {
            modelItemDTO = modelItemDTO.clone(reductionBrevetsDTO != null && reductionBrevetsDTO.getValue() != null ? reductionBrevetsDTO.getValue() : null, 11, null);
        }
        return modelItemDTO;
    }
}

