/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import java.util.Set;

public class KantonsAuswahlInterkantonaleSteuerteilungValidator
implements Validator {
    private final Reference formTable;
    private final Reference kantonA;
    private final Reference kantonB;
    private final Reference kantonC;
    private final Reference kantonD;
    private final Reference kantonE;
    private static final String ERROR_ANNEXE_J_AJ_KANTON_DOPPELT_DEFINIERT = "error.AnnexeJ.AJ.kantonDoppeltDefiniert";

    public KantonsAuswahlInterkantonaleSteuerteilungValidator(Reference formTable, Reference kantonA, Reference kantonB, Reference kantonC, Reference kantonD, Reference kantonE) {
        this.formTable = formTable;
        this.kantonA = kantonA;
        this.kantonB = kantonB;
        this.kantonC = kantonC;
        this.kantonD = kantonD;
        this.kantonE = kantonE;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.kantonA == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.kantonA.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.kantonB == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.kantonB.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.kantonC == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.kantonC.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.kantonD == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.kantonD.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.kantonE == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.kantonE.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Long curentValueKanton = (Long)modelItemDTO.getValue();
        ModelItemDTO result = modelItemDTO;
        ModelItemDTO miDTO = dataModel.get((Object)this.formTable.getName());
        if (miDTO == null || miDTO.getValue() == null) {
            return result;
        }
        Set annexeJSet = (Set)miDTO.getValue();
        String annexeJKeyMin = null;
        for (Object anAnnexeJSet : annexeJSet) {
            Long valueKantonD;
            Long valueKantonC;
            Long valueKantonB;
            Long valueKantonA;
            String annexeJKey = anAnnexeJSet.toString();
            if (annexeJKeyMin == null || Long.parseLong(annexeJKey) < Long.parseLong(annexeJKeyMin)) {
                annexeJKeyMin = annexeJKey;
            }
            if (curentValueKanton == null) continue;
            String keyKantonA = EngineUtil.mergeModelKey((String)this.kantonA.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonADTO = dataModel.get((Object)keyKantonA);
            Long l = valueKantonA = kantonADTO != null ? (Long)kantonADTO.getValue() : null;
            if (valueKantonA != null && !keyKantonA.equals(dataModelKey) && valueKantonA.equals(curentValueKanton)) {
                result = result.clone(4, ERROR_ANNEXE_J_AJ_KANTON_DOPPELT_DEFINIERT, null, 4);
                return result;
            }
            String keyKantonB = EngineUtil.mergeModelKey((String)this.kantonB.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonBDTO = dataModel.get((Object)keyKantonB);
            Long l2 = valueKantonB = kantonBDTO != null ? (Long)kantonBDTO.getValue() : null;
            if (valueKantonB != null && !keyKantonB.equals(dataModelKey) && valueKantonB.equals(curentValueKanton)) {
                result = result.clone(4, ERROR_ANNEXE_J_AJ_KANTON_DOPPELT_DEFINIERT, null, 4);
                return result;
            }
            String keyKantonC = EngineUtil.mergeModelKey((String)this.kantonC.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonCDTO = dataModel.get((Object)keyKantonC);
            Long l3 = valueKantonC = kantonCDTO != null ? (Long)kantonCDTO.getValue() : null;
            if (valueKantonC != null && !keyKantonC.equals(dataModelKey) && valueKantonC.equals(curentValueKanton)) {
                result = result.clone(4, ERROR_ANNEXE_J_AJ_KANTON_DOPPELT_DEFINIERT, null, 4);
                return result;
            }
            String keyKantonD = EngineUtil.mergeModelKey((String)this.kantonD.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonDDTO = dataModel.get((Object)keyKantonD);
            Long l4 = valueKantonD = kantonDDTO != null ? (Long)kantonDDTO.getValue() : null;
            if (valueKantonD != null && !keyKantonD.equals(dataModelKey) && valueKantonD.equals(curentValueKanton)) {
                result = result.clone(4, ERROR_ANNEXE_J_AJ_KANTON_DOPPELT_DEFINIERT, null, 4);
                return result;
            }
            String keyKantonE = EngineUtil.mergeModelKey((String)this.kantonE.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonEDTO = dataModel.get((Object)keyKantonE);
            Long valueKantonE = kantonEDTO != null ? (Long)kantonEDTO.getValue() : null;
            if (valueKantonE == null || keyKantonE.equals(dataModelKey) || !valueKantonE.equals(curentValueKanton)) continue;
            result = result.clone(4, ERROR_ANNEXE_J_AJ_KANTON_DOPPELT_DEFINIERT, null, 4);
            return result;
        }
        return result;
    }
}

