/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import java.util.Set;

public class ExtractColumnFromOtherTable
implements Validator {
    private final Reference destinationTable;
    private final Reference sourceTable;
    private final Reference indexItem;
    private final Reference sourceItem;

    public ExtractColumnFromOtherTable(Reference destinationTable, Reference sourceTable, Reference indexItem, Reference sourceItem) {
        this.destinationTable = destinationTable;
        this.sourceTable = sourceTable;
        this.indexItem = indexItem;
        this.sourceItem = sourceItem;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.destinationTable.registerListenerOnReference(logicModel, logicModelItem, true);
        this.sourceTable.registerListenerOnReference(logicModel, logicModelItem, true);
        this.indexItem.registerListenerOnReference(logicModel, logicModelItem, true);
        this.sourceItem.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Set sourceTableIndices;
        long result = 0L;
        String destTableDMK = EngineUtil.mergeModelKey((String)this.destinationTable.getName(), (String)dataModelKey);
        String destTableEntryIndex = EngineUtil.getLastKeyPart((String)destTableDMK);
        String sourceTableDMK = EngineUtil.mergeModelKey((String)this.sourceTable.getName(), (String)dataModelKey);
        ModelItemDTO sourceTableDTO = dataModel.get((Object)sourceTableDMK);
        Set set = sourceTableIndices = sourceTableDTO != null ? (Set)sourceTableDTO.getValue() : null;
        if (sourceTableIndices != null) {
            for (Object sourceTableIndice : sourceTableIndices) {
                Object value;
                ModelItemDTO sourceDTO;
                String index = sourceTableIndice.toString();
                String dmk = EngineUtil.mergeModelKey((String)this.indexItem.getName(), (String)(sourceTableDMK + "." + index));
                ModelItemDTO indexDTO = dataModel.get((Object)dmk);
                if (indexDTO == null || !destTableEntryIndex.equals(indexDTO.getValue()) || (sourceDTO = dataModel.get((Object)(dmk = EngineUtil.mergeModelKey((String)this.sourceItem.getName(), (String)(sourceTableDMK + "." + index))))) == null || !((value = sourceDTO.getValue()) instanceof Number)) continue;
                result += ((Number)value).longValue();
            }
        }
        return modelItemDTO.clone((Object)result);
    }
}

