/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.HashSet;
import java.util.Map;

public class DuplicateTableEntryPreventor
implements Validator {
    private final Reference fieldToCheck;

    public DuplicateTableEntryPreventor(Reference fieldToCheck) {
        this.fieldToCheck = fieldToCheck;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.fieldToCheck.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        String tableEntryValue = "";
        String modelItemValue = "";
        if (this.fieldToCheck == null) {
            return modelItemDTO;
        }
        ModelItemDTO result = modelItemDTO;
        LogicModelItem containingTable = this.fieldToCheck.getReference().getParent();
        if (containingTable == null) {
            return modelItemDTO;
        }
        HashSet tableEntries = (HashSet)dataModel.get((Object)containingTable.getName()).getValue();
        for (String entry : tableEntries) {
            String fieldToCompareToDMK = this.fieldToCheck.getReference().getNameWithTableIndexShapes().replace("#", entry);
            ModelItemDTO tableEntryModelItem = dataModel.get((Object)fieldToCompareToDMK);
            if (tableEntryModelItem == null || tableEntryModelItem.getValue() == null) {
                return modelItemDTO;
            }
            if (tableEntryModelItem.getValue() != null) {
                tableEntryValue = tableEntryModelItem.getValue().toString();
            }
            if (modelItemDTO.getValue() != null) {
                modelItemValue = modelItemDTO.getValue().toString();
            }
            if (!modelItemDTO.isTouched() || dataModelKey.contains(entry) || !tableEntryValue.equalsIgnoreCase(modelItemValue)) continue;
            result = result.clone(4, "error.tableEntry.duplicate", null, 4);
            return result;
        }
        return modelItemDTO;
    }
}

