/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import java.util.Set;

public class CopyValueFromFormWithComboSelection
implements Validator {
    private final Reference formTable;
    private final Reference comboItem;
    private final Reference selectionItem;
    private final Reference sourceItem;

    public CopyValueFromFormWithComboSelection(Reference formTable, Reference comboItem, Reference selectionItem, Reference sourceItem) {
        this.formTable = formTable;
        this.comboItem = comboItem;
        this.selectionItem = selectionItem;
        this.sourceItem = sourceItem;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.formTable.registerListenerOnReference(logicModel, logicModelItem, false);
        this.comboItem.registerListenerOnReference(logicModel, logicModelItem, true);
        this.selectionItem.registerListenerOnReference(logicModel, logicModelItem, false);
        this.sourceItem.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Set formTableIndices;
        ModelItemDTO result = null;
        String formTableDMK = EngineUtil.mergeModelKey((String)this.formTable.getName(), (String)dataModelKey);
        ModelItemDTO formTableDTO = dataModel.get((Object)formTableDMK);
        Set set = formTableIndices = formTableDTO != null ? (Set)formTableDTO.getValue() : null;
        if (formTableIndices != null) {
            for (Object formTableIndice : formTableIndices) {
                String selectionItemDMK;
                ModelItemDTO selectionItemDTO;
                String formTableEntryDMK = formTableDMK + "." + formTableIndice;
                String comboItemDMK = EngineUtil.mergeModelKey((String)this.comboItem.getName(), (String)formTableEntryDMK);
                ModelItemDTO comboItemDTO = dataModel.get((Object)comboItemDMK);
                if (comboItemDTO == null || comboItemDTO.getValue() == null || (selectionItemDTO = dataModel.get((Object)(selectionItemDMK = EngineUtil.mergeModelKey((String)this.selectionItem.getName(), (String)dataModelKey)))) == null || selectionItemDTO.getValue() == null || !comboItemDTO.getValue().equals(selectionItemDTO.getValue())) continue;
                String sourceItemDMK = EngineUtil.mergeModelKey((String)this.sourceItem.getName(), (String)formTableEntryDMK);
                result = dataModel.get((Object)sourceItemDMK);
            }
        }
        return result != null ? result : new ModelItemDTO(null);
    }
}

