/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import java.util.Set;

public class ChoixCommunesRepartitionIntercommunaleValidator
implements Validator {
    private final Reference formTable;
    private final Reference communeA;
    private final Reference communeB;
    private final Reference communeC;
    private final Reference communeD;
    private final Reference communeE;

    public ChoixCommunesRepartitionIntercommunaleValidator(Reference formTable, Reference communeA, Reference communeB, Reference communeC, Reference communeD, Reference communeE) {
        this.formTable = formTable;
        this.communeA = communeA;
        this.communeB = communeB;
        this.communeC = communeC;
        this.communeD = communeD;
        this.communeE = communeE;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.communeA == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeA.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeB == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeB.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeC == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeC.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeD == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeD.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeE == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeE.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Long curentValueKanton = (Long)modelItemDTO.getValue();
        ModelItemDTO result = modelItemDTO;
        ModelItemDTO miDTO = dataModel.get((Object)this.formTable.getName());
        if (miDTO == null || miDTO.getValue() == null) {
            return result;
        }
        Set annexeJSet = (Set)miDTO.getValue();
        String annexeJKeyMin = null;
        for (Object anAnnexeJSet : annexeJSet) {
            Long valueCommuneD;
            Long valueCommuneC;
            Long valueCommuneB;
            Long valueCommuneA;
            String annexeJKey = anAnnexeJSet.toString();
            if (annexeJKeyMin == null || Long.parseLong(annexeJKey) < Long.parseLong(annexeJKeyMin)) {
                annexeJKeyMin = annexeJKey;
            }
            if (curentValueKanton == null) continue;
            String keyCommuneA = EngineUtil.mergeModelKey((String)this.communeA.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonADTO = dataModel.get((Object)keyCommuneA);
            Long l = valueCommuneA = kantonADTO != null ? (Long)kantonADTO.getValue() : null;
            if (valueCommuneA != null && !keyCommuneA.equals(dataModelKey) && valueCommuneA.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            String keyCommuneB = EngineUtil.mergeModelKey((String)this.communeB.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonBDTO = dataModel.get((Object)keyCommuneB);
            Long l2 = valueCommuneB = kantonBDTO != null ? (Long)kantonBDTO.getValue() : null;
            if (valueCommuneB != null && !keyCommuneB.equals(dataModelKey) && valueCommuneB.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            String keyCommuneC = EngineUtil.mergeModelKey((String)this.communeC.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonCDTO = dataModel.get((Object)keyCommuneC);
            Long l3 = valueCommuneC = kantonCDTO != null ? (Long)kantonCDTO.getValue() : null;
            if (valueCommuneC != null && !keyCommuneC.equals(dataModelKey) && valueCommuneC.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            String keyCommuneD = EngineUtil.mergeModelKey((String)this.communeD.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonDDTO = dataModel.get((Object)keyCommuneD);
            Long l4 = valueCommuneD = kantonDDTO != null ? (Long)kantonDDTO.getValue() : null;
            if (valueCommuneD != null && !keyCommuneD.equals(dataModelKey) && valueCommuneD.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            String keyCommuneE = EngineUtil.mergeModelKey((String)this.communeE.getName(), (String)(this.formTable.getName() + "." + annexeJKey));
            ModelItemDTO kantonEDTO = dataModel.get((Object)keyCommuneE);
            Long valueCommuneE = kantonEDTO != null ? (Long)kantonEDTO.getValue() : null;
            if (valueCommuneE == null || keyCommuneE.equals(dataModelKey) || !valueCommuneE.equals(curentValueKanton)) continue;
            result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
            return result;
        }
        return result;
    }
}

