/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.modelitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Arrays;
import java.util.Map;

public class RecursiveCalc
extends Calc {
    private static final int CALC_ITERATIONS = 10;
    private final Reference triggerRef;

    public RecursiveCalc(String name, CalcItem[] calcItems) {
        this(name, calcItems, null);
    }

    public RecursiveCalc(String name, CalcItem[] calcItems, Reference triggerRef) {
        super(name, null, Arrays.asList(calcItems), null, false, false, false);
        this.triggerRef = triggerRef;
    }

    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        if (this.triggerRef != null) {
            this.triggerRef.registerListenerOnReference(logicModel, (LogicModelItem)this, false);
        }
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        boolean forceSkip;
        String triggerDMK;
        if (this.triggerRef != null) {
            triggerDMK = EngineUtil.mergeModelKey((String)this.triggerRef.getName(), (String)dataModelKey);
            ModelItemDTO triggerItem = dataModel.get((Object)triggerDMK);
            forceSkip = triggerItem == null || !"doCalculate".equals(triggerItem.getValue());
        } else {
            triggerDMK = null;
            forceSkip = false;
        }
        String triggerAction = null;
        if (dataModel.isRecalculating() || !forceSkip) {
            String recursionFlagKey = "RecursionFlag_" + this.getName();
            Map sessionAttributes = dataModel.getSessionAttributes();
            if (!sessionAttributes.containsKey(recursionFlagKey)) {
                dataModel.getSessionAttributes().put(recursionFlagKey, true);
                for (int i = 0; i < 10; ++i) {
                    super.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
                }
                dataModel.getSessionAttributes().remove(recursionFlagKey);
            }
            if (triggerDMK != null) {
                ModelItemDTO item = new ModelItemDTO((Object)"", 1);
                item.setTouched();
                dataModel.getAsyncUpdates().put(triggerDMK, item);
            }
            triggerAction = "";
        } else if (forceSkip) {
            triggerAction = "showError";
        }
        if (triggerDMK != null && triggerAction != null) {
            ModelItemDTO item = new ModelItemDTO((Object)triggerAction, 1);
            item.setTouched();
            dataModel.getAsyncUpdates().put(triggerDMK, item);
        }
    }
}

