/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.expertdisplay;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.BarcodeHelper;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.BarcodeItem;
import ch.dvbern.tax.ge.pm.envoi.ReleaseMode;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

public class GeBarcodeGenerator
implements Barcode2DGenerator {
    private final boolean zipResult;
    private final long timestamp;
    private final ReleaseMode releaseMode;
    private final boolean hasAttachments;
    private static final String TAXME_XML = "TaxMe.xml";
    private static final String ENCODING = "ISO-8859-15";
    private final Random random = new Random();
    private Map<String, BarcodeItem> result = null;

    public GeBarcodeGenerator() {
        this(true, System.currentTimeMillis(), ReleaseMode.PRINT, false);
    }

    public GeBarcodeGenerator(boolean zipResult, long timestamp, ReleaseMode releaseMode, boolean hasAttachments) {
        this.zipResult = zipResult;
        this.timestamp = timestamp;
        this.releaseMode = releaseMode;
        this.hasAttachments = hasAttachments;
    }

    public byte[] generateId(ExpertDisplayModel.RequestContext req) {
        byte[] id = new byte[4];
        id[0] = 3;
        id[1] = 1;
        byte[] rand = new byte[2];
        this.random.nextBytes(rand);
        id[2] = rand[0];
        id[3] = rand[1];
        return id;
    }

    public byte getContentType() {
        return 0;
    }

    public byte[] generateData(ExpertDisplayModel.RequestContext requestContext) {
        ExpertDisplayModel.ProtectedMap dataModel = requestContext.getDataModel();
        Map logicModel = requestContext.getLogicModelItems();
        this.result = new HashMap<String, BarcodeItem>();
        for (Map.Entry entry : dataModel.entrySet()) {
            String dmk = (String)entry.getKey();
            ModelItemDTO modelItemDTO = (ModelItemDTO)entry.getValue();
            LogicModelItem logicModelItem = (LogicModelItem)logicModel.get(EngineUtil.removeTableIndices((String)dmk));
            if (logicModelItem == null) continue;
            List pkts = logicModelItem.getPersistenceKeyTemplates();
            Long index = null;
            for (String persistenceKey : pkts) {
                String key = (String)entry.getKey();
                Object value = ((ModelItemDTO)entry.getValue()).getValue();
                persistenceKey = EngineUtil.convertPersistenceKey((String)persistenceKey, (String)dmk);
                StringTokenizer pKeyTokenizer = new StringTokenizer(persistenceKey, ";");
                String isToWrite = pKeyTokenizer.nextToken();
                String formular = pKeyTokenizer.nextToken();
                String code = pKeyTokenizer.nextToken();
                String format = pKeyTokenizer.nextToken();
                boolean bIsToWrite = true;
                boolean isWarning = modelItemDTO.getState() == 2;
                boolean skipZero = false;
                if (pKeyTokenizer.hasMoreElements()) {
                    Object next = pKeyTokenizer.nextToken();
                    if (((String)next).equalsIgnoreCase("SkipZero")) {
                        skipZero = true;
                    } else {
                        if (((String)next).length() == 10) {
                            String poidsFort = ((String)next).substring(0, 5);
                            String poidsFaible = ((String)next).substring(5);
                            next = poidsFaible + poidsFort;
                        }
                        index = Long.valueOf((String)next);
                    }
                }
                if (pKeyTokenizer.hasMoreElements()) {
                    skipZero = pKeyTokenizer.nextToken().equalsIgnoreCase("SkipZero");
                }
                if (modelItemDTO.getValue() == null || value == null || skipZero && (!skipZero || value.toString().equals("0"))) continue;
                BarcodeItem item = new BarcodeItem(formular, code, format, value, key, index, isWarning, true);
                this.addToResult(item);
            }
        }
        try {
            return this.generateBarcodeContent(dataModel, this.result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addToResult(BarcodeItem item) {
        StringBuilder buf = new StringBuilder(item.getFormular()).append(";").append(item.getCode());
        if (item.getIndex() != null) {
            buf.append(";").append(item.getIndex().toString());
        }
        this.result.put(buf.toString(), item);
    }

    private byte[] generateBarcodeContent(@Nonnull ExpertDisplayModel.ProtectedMap dataModel, @Nonnull Map<String, BarcodeItem> tempResult) throws IOException {
        ModelItemDTO selectionAF;
        String anneeTaxation = String.valueOf(ApplicationConfig.getInstance().getJahr());
        String name = "";
        String addr = "";
        String zip = "";
        String city = "";
        String iddecla = "";
        ModelItemDTO selectionSA = dataModel.get((Object)"Selection.SA");
        String noContribuable = null;
        if (selectionSA != null && selectionSA.getValue() != null && ((Boolean)selectionSA.getValue()).booleanValue()) {
            ModelItemDTO raisonSociale = dataModel.get((Object)"Declaration.Form1.RaisonSociale");
            ModelItemDTO adresse = dataModel.get((Object)"Declaration.Form1.Adresse");
            ModelItemDTO cp = dataModel.get((Object)"Declaration.Form1.CP");
            ModelItemDTO ville = dataModel.get((Object)"Declaration.Form1.Ville");
            ModelItemDTO codeDecla = dataModel.get((Object)"Declaration.Form1.CodeDeclarationBarcode");
            ModelItemDTO numeroContribuable = dataModel.get((Object)"Declaration.Form1.NumeroContribuable");
            if (raisonSociale != null && raisonSociale.getValue() != null) {
                name = raisonSociale.getValue().toString();
            }
            if (adresse != null && adresse.getValue() != null) {
                addr = adresse.getValue().toString();
            }
            if (dataModel.get((Object)"Declaration.Form1.RaisonSoc") != null && cp != null && cp.getValue() != null) {
                zip = cp.getValue().toString();
            }
            if (ville != null && ville.getValue() != null) {
                city = ville.getValue().toString();
            }
            if (codeDecla != null && codeDecla.getValue() != null) {
                iddecla = codeDecla.getValue().toString();
            }
            if (numeroContribuable != null && numeroContribuable.getValue() != null) {
                noContribuable = numeroContribuable.getValue().toString();
            }
        }
        if ((selectionAF = dataModel.get((Object)"Selection.AF")) != null && selectionAF.getValue() != null && ((Boolean)selectionAF.getValue()).booleanValue()) {
            ModelItemDTO raisonSociale = dataModel.get((Object)"Declaration_af.Form1_af.RaisonSociale");
            ModelItemDTO adresse = dataModel.get((Object)"Declaration_af.Form1_af.Adresse");
            ModelItemDTO cp = dataModel.get((Object)"Declaration_af.Form1_af.CP");
            ModelItemDTO ville = dataModel.get((Object)"Declaration_af.Form1_af.Ville");
            ModelItemDTO codeDecla = dataModel.get((Object)"Declaration_af.Form1_af.CodeDeclarationBarcode");
            ModelItemDTO numeroContribuable = dataModel.get((Object)"Declaration_af.Form1_af.NumeroContribuable");
            if (raisonSociale != null && raisonSociale.getValue() != null) {
                name = raisonSociale.getValue().toString();
            }
            if (adresse != null && adresse.getValue() != null) {
                addr = adresse.getValue().toString();
            }
            if (dataModel.get((Object)"Declaration_af.Form1_af.RaisonSoc") != null && cp != null && cp.getValue() != null) {
                zip = cp.getValue().toString();
            }
            if (ville != null && ville.getValue() != null) {
                city = ville.getValue().toString();
            }
            if (codeDecla != null && codeDecla.getValue() != null) {
                iddecla = codeDecla.getValue().toString();
            }
            if (numeroContribuable != null && numeroContribuable.getValue() != null) {
                noContribuable = numeroContribuable.getValue().toString();
            }
        }
        name = StringUtil.escapeAndFilterXml((CharSequence)name);
        addr = StringUtil.escapeAndFilterXml((CharSequence)addr);
        zip = StringUtil.escapeAndFilterXml((CharSequence)zip);
        city = StringUtil.escapeAndFilterXml((CharSequence)city);
        iddecla = StringUtil.escapeAndFilterXml((CharSequence)iddecla);
        String content = BarcodeHelper.generate(tempResult, anneeTaxation, name, addr, zip, city, noContribuable, iddecla, selectionSA, selectionAF, this.timestamp, this.releaseMode, this.hasAttachments);
        byte[] data = content.getBytes(ENCODING);
        if (this.zipResult) {
            return ZipHelper.zip((byte[])data, (String)TAXME_XML);
        }
        return data;
    }

    private void createAsciiFile(String zpv, byte[] content) {
        try {
            FileOutputStream os = new FileOutputStream(zpv + ".xml");
            os.write(content);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

