/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.expertdisplay;

import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class BarcodeItem
implements Comparable<BarcodeItem> {
    private String formular;
    private String code;
    private String format;
    private Object value;
    private String key;
    private final boolean isWarning;
    private boolean isToWrite;
    private Long index;

    public BarcodeItem(String formular, String code, String format, Object val, String key, Long index, boolean isWarning, boolean isToWrite) {
        this.code = code;
        this.format = format;
        this.formular = formular;
        this.key = key;
        this.index = index;
        this.isWarning = isWarning;
        this.isToWrite = isToWrite;
        this.value = this.convertValue(val);
    }

    public BarcodeItem(String formular, String code, String format, Object val, String key, Long index) {
        this.code = code;
        this.format = format;
        this.formular = formular;
        this.value = this.convertValue(val);
        this.key = key;
        this.index = index;
        this.isWarning = false;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormular() {
        return this.formular;
    }

    public void setFormular(String formular) {
        this.formular = formular;
    }

    public String getValue() {
        return (String)this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public boolean isToWrite() {
        return this.isToWrite;
    }

    private String convertValue(Object val) {
        if (this.getFormat().equals("A")) {
            return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
        }
        if (this.getFormat().startsWith("F")) {
            int numberAfterComa = Integer.parseInt(this.getFormat().substring(1));
            StringBuilder buf = new StringBuilder("0.");
            for (int i = 0; i < numberAfterComa; ++i) {
                buf.append("0");
            }
            DecimalFormatSymbols symbol = new DecimalFormatSymbols();
            symbol.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat(buf.toString(), symbol);
            return df.format(((Number)val).doubleValue());
        }
        if (this.getFormat().equals("N")) {
            String number = val.toString();
            if (this.isScientificNotation(number)) {
                number = val instanceof Integer ? String.valueOf(new BigDecimal(number).intValue()) : new BigDecimal(number).toPlainString();
            }
            return number;
        }
        if (this.getFormat().equals("D")) {
            Date dateToDisplay = (Date)val;
            return new SimpleDateFormat("yyyyMMdd").format(dateToDisplay);
        }
        if (this.getFormat().equals("C")) {
            switch (this.getCode()) {
                case "2.1.1_1": {
                    if (val instanceof Long) {
                        long longValue = (Long)val;
                        if (longValue == 1L) {
                            return "AS";
                        }
                        if (longValue == 2L) {
                            return "AL";
                        }
                        return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
                    }
                    return "";
                }
                case "2.1.2_1": {
                    if (val instanceof Long) {
                        long longValue = (Long)val;
                        if (longValue == 1L) {
                            return "A";
                        }
                        if (longValue == 2L) {
                            return "%";
                        }
                        if (longValue == 3L) {
                            return "S";
                        }
                        return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
                    }
                    return "";
                }
            }
            return "";
        }
        return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
    }

    protected String getCodeF() {
        StringTokenizer token;
        String code = this.getCode();
        if (code.indexOf(45) != -1) {
            token = new StringTokenizer(code, "-");
        } else if (code.indexOf(95) != -1) {
            token = new StringTokenizer(code, "_");
        } else if (code.indexOf(42) != -1) {
            token = new StringTokenizer(code, "*");
        } else {
            return code;
        }
        return token.nextToken();
    }

    protected String getCodeC() {
        StringTokenizer token;
        String code = this.getCode();
        if (code.indexOf(45) != -1) {
            token = new StringTokenizer(code, "-");
        } else if (code.indexOf(95) != -1) {
            token = new StringTokenizer(code, "_");
        } else if (code.indexOf(42) != -1) {
            token = new StringTokenizer(code, "*");
        } else {
            return code;
        }
        token.nextToken();
        return token.nextToken();
    }

    @Override
    public int compareTo(BarcodeItem toCompare) {
        if (this.getIndex() != null && toCompare.getIndex() != null) {
            return this.getIndex().compareTo(toCompare.getIndex());
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Long getIndex() {
        return this.index;
    }

    public void setIndex(Long index) {
        this.index = index;
    }

    public String toString() {
        return this.code + " " + this.format + " " + this.formular + " " + this.index + " " + this.isToWrite + " " + this.isWarning + " " + this.key + " " + this.value;
    }

    private boolean isScientificNotation(String numberString) {
        try {
            new BigDecimal(numberString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return numberString.toUpperCase().contains("E") && (numberString.charAt(1) == '.' || numberString.charAt(2) == '.');
    }
}

