/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.expertdisplay;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.BarcodeItem;
import ch.dvbern.tax.ge.pm.envoi.ReleaseMode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BarcodeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BarcodeHelper.class);
    private static final String GETAX_PM = "GeTaxPM";
    private static final String CONFIG_PATH_RESOURCES_BARCODE_AF = "config/cd/resources/barcode_af.txt";
    private static final String CONFIG_PATH_RESOURCES_BARCODE_SA = "config/cd/resources/barcode.txt";
    private static Map<String, BarcodeItem> barcodeModel = null;
    private static final String COMMENT = "#";
    private static final char SPACE = ' ';
    private static final String CRLF = "\r\n";
    private static final String QUOTE = "\"";
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"ISO-8859-15\" ?>";
    private static final String BEGIN_DOC = "<doc>";
    private static final String END_DOC = "</doc>";
    private static final String END_FORM = "</Form>";
    private static final String BEGIN_FORM = "<Form";
    private static final String INTERFACE_HEADER = "ii";
    private static final String INTERFACE_DEF = "id";
    private static final String BEGIN_FORMULAR_HEADER = "<fh id=";
    private static final String END_FORMULAR_HEADER = "</fh>";
    private static final String FORMULAR_DESC = "desc=";
    private static final String BEGIN_FORMULAR_DATA = "<fd>";
    private static final String END_FORMULAR_DATA = "</fd>";
    private static final String BEGIN_TABLE_ROW = "<TableRow>";
    private static final String END_TABLE_ROW = "</TableRow>";
    private static final String BEGIN_TABLE = "<tb>";
    private static final String END_TABLE = "</tb>";
    private static final String BEGIN_TABLE_CELL = "<td>";
    private static final String END_TABLE_CELL = "</td>";
    private static final String BEGIN_TAG = "<";
    private static final String END_TAG = "/>";
    private static final String END_LINE_TAG = ">";
    private static final String PERIOD = "period=";
    private static final String DATE_NOW = "dategeneration=";
    private static final String PROVIDER = "provider=";
    private static final String VERSION = "version=";
    private static final String MODE = "mode=";
    private static final String NAME = "name=";
    private static final String ADDRESS = "addr=";
    private static final String ZIP = "zip=";
    private static final String CITY = "city=";
    private static final String NO_CONTRIBUABLE = "sno=";
    private static final String ID_DECLA = "iddecla=";
    private static final String TYPE_APP = "type=";
    private static final String TYPE_APP_SA = "SA";
    private static final String TYPE_APP_AF = "AF";
    private static final String JUSTIF_ELECTRONIQUE = "justifelec=";
    private static final String BEGIN_FIELD = "<dr f=";
    private static final String CODE = "c=";
    private static final String VALUE = "v=";
    private static final String MODIFIED = "m=";
    private static final String DASH = "-";
    private static final String VERSION_SOUMISSION = "TLV";
    private static final String VERSION_DEPOT = "DPL";
    private static final String VERSION_PIECEJOINTES = "J";

    private BarcodeHelper() {
    }

    public static String generate(@Nonnull Map<String, BarcodeItem> result, @Nonnull String anneeTaxation, @Nonnull String name, @Nonnull String addr, @Nonnull String zip, @Nonnull String city, @Nonnull String noContribuable, @Nonnull String iddecla, @Nullable ModelItemDTO selectionSA, @Nullable ModelItemDTO selectionAF, long timestamp, ReleaseMode releaseMode, boolean hasAttachments) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSXXX");
        sdf.setTimeZone(ApplicationConfig.TIMEZONE);
        String dateGeneration = sdf.format(timestamp);
        String version = TaxmeConfig.getApplicationVersionBarcode();
        StringBuffer buf = new StringBuffer();
        buf.append(BarcodeHelper.generateBeginDoc());
        buf.append(BarcodeHelper.generateBeginFile(anneeTaxation, dateGeneration, GETAX_PM, version, releaseMode, hasAttachments));
        barcodeModel = result;
        File barcodeFormular = null;
        if (selectionSA != null && selectionSA.getValue() != null && ((Boolean)selectionSA.getValue()).booleanValue()) {
            buf.append(BarcodeHelper.generateBarcodeHeaderElements(iddecla, noContribuable, city, name, addr, zip, TYPE_APP_SA));
            barcodeFormular = new File(CONFIG_PATH_RESOURCES_BARCODE_SA);
        } else if (selectionAF != null && selectionAF.getValue() != null && ((Boolean)selectionAF.getValue()).booleanValue()) {
            buf.append(BarcodeHelper.generateBarcodeHeaderElements(iddecla, noContribuable, city, name, addr, zip, TYPE_APP_AF));
            barcodeFormular = new File(CONFIG_PATH_RESOURCES_BARCODE_AF);
        }
        if (barcodeFormular != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(barcodeFormular))));
            BarcodeHelper.readLine(releaseMode, buf, reader);
            reader.close();
        }
        buf.append(BarcodeHelper.generateEndDoc());
        return buf.toString();
    }

    private static void readLine(@Nonnull ReleaseMode releaseMode, @Nonnull StringBuffer buf, @Nonnull BufferedReader reader) throws IOException {
        String line = reader.readLine();
        boolean overread = false;
        while (line != null) {
            try {
                if (!line.startsWith(COMMENT)) {
                    if (line.startsWith(BEGIN_FORM)) {
                        StringTokenizer sk = new StringTokenizer(line, ";");
                        sk.nextToken();
                        String formId = sk.nextToken();
                        String formName = sk.nextToken();
                        buf.append(BarcodeHelper.generateBeginFormular(formId, formName));
                    } else if (END_FORM.equals(line)) {
                        buf.append(BarcodeHelper.generateEndFormular());
                    } else if (BEGIN_TABLE_ROW.equals(line)) {
                        BarcodeHelper.generateTable(buf, reader);
                    } else if (line.startsWith("17")) {
                        item = barcodeModel.get(line);
                        if (item != null) {
                            buf.append(BarcodeHelper.generateField(item));
                        }
                    } else if (line.startsWith("12") || line.startsWith("13")) {
                        BarcodeHelper.readForm1213(buf, line);
                    } else if (line.startsWith("10")) {
                        if (!overread && line.indexOf(45) != -1) {
                            buf.append(BarcodeHelper.generateAnnexeH());
                            overread = true;
                        }
                    } else if (line.startsWith("<Table")) {
                        BarcodeHelper.readTable(buf, reader, line);
                    } else {
                        item = barcodeModel.get(line);
                        if (item != null) {
                            buf.append(BarcodeHelper.generateField(item));
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOG.info("Exception at: " + line);
                throw e;
            }
            line = reader.readLine();
        }
    }

    private static void readTable(@Nonnull StringBuffer buf, @Nonnull BufferedReader reader, @Nonnull String line) throws IOException {
        String maxInput;
        StringTokenizer tokenizer = new StringTokenizer(line, ":");
        tokenizer.nextToken();
        String idTableDefinition = tokenizer.nextToken();
        StringTokenizer token = new StringTokenizer(idTableDefinition, "_");
        String id = token.nextToken();
        if (id.endsWith(END_LINE_TAG)) {
            id = id.replaceAll(END_LINE_TAG, "");
        }
        if ((maxInput = token.nextToken()).endsWith(END_LINE_TAG)) {
            maxInput = maxInput.replaceAll(END_LINE_TAG, "");
        }
        int maxNumberOfInput = Integer.parseInt(maxInput);
        ArrayList<BarcodeItem> allItemsForIdDefinition = new ArrayList<BarcodeItem>();
        for (int i = -1; i < maxNumberOfInput; ++i) {
            List<BarcodeItem> items = BarcodeHelper.getAllItemsForIdTableDefinitition(id + "_" + (i + 1));
            if (items.isEmpty()) continue;
            allItemsForIdDefinition.addAll(items);
        }
        Collections.sort(allItemsForIdDefinition);
        ArrayList<String> ids = new ArrayList<String>();
        String lineInTable = reader.readLine();
        String endTable = "</Table>";
        if (lineInTable != null) {
            while (!lineInTable.equals("</Table>")) {
                ids.add(lineInTable);
                lineInTable = reader.readLine();
            }
        }
        Map<Integer, List<BarcodeItem>> barcodeAnnexeJTableItems = BarcodeHelper.getSortedTableItemsForIdsAnnexeJ(ids);
        if (!allItemsForIdDefinition.isEmpty()) {
            buf.append(BarcodeHelper.generateTableBegin());
            int numberOfLine = allItemsForIdDefinition.size() / (maxNumberOfInput + 1);
            if (allItemsForIdDefinition.size() % (maxNumberOfInput + 1) > 0) {
                ++numberOfLine;
            }
            ArrayList<Integer> indices = BarcodeHelper.getAllIndicesOfTable(allItemsForIdDefinition);
            for (int i = 0; i < numberOfLine; ++i) {
                buf.append(BarcodeHelper.generateTableCellBegin());
                BarcodeHelper.generateDefinition(i, maxNumberOfInput + 1, allItemsForIdDefinition, buf);
                if (!barcodeAnnexeJTableItems.isEmpty()) {
                    BarcodeHelper.generateEntries(indices.get(i), barcodeAnnexeJTableItems, buf);
                }
                buf.append(BarcodeHelper.generateTableCellEnd());
            }
            buf.append(BarcodeHelper.generateTableEnd());
        }
    }

    private static ArrayList<Integer> getAllIndicesOfTable(List<BarcodeItem> allItemsForIdDefinition) {
        HashSet<Integer> indices = new HashSet<Integer>();
        for (BarcodeItem obj : allItemsForIdDefinition) {
            indices.add((int)(obj.getIndex() / 100000L));
        }
        ArrayList<Integer> list = new ArrayList<Integer>(indices);
        Collections.sort(list);
        return list;
    }

    private static void readForm1213(@Nonnull StringBuffer buf, String line) {
        BarcodeItem item;
        if (line.indexOf(45) != -1) {
            ArrayList<BarcodeItem> allItemsForId = new ArrayList<BarcodeItem>();
            StringTokenizer token = new StringTokenizer(line, DASH);
            String id = token.nextToken();
            int maxNumberOfInput = Integer.parseInt(token.nextToken());
            for (int i = 0; i < maxNumberOfInput; ++i) {
                allItemsForId.addAll(BarcodeHelper.getAllItemsForId(id + DASH + (i + 1)));
            }
            Collections.sort(allItemsForId);
            for (Object e : allItemsForId) {
                BarcodeItem item2 = (BarcodeItem)e;
                buf.append(BarcodeHelper.generateFieldAnnexeJK(item2));
            }
        } else if (line.indexOf(42) != -1 && (item = barcodeModel.get(line)) != null) {
            buf.append(BarcodeHelper.generateField(item));
        }
    }

    private static Map<String, TreeSet<BarcodeItem>> getAllAnnexeHItems() {
        TreeMap<String, TreeSet<BarcodeItem>> allAnnexeH = new TreeMap<String, TreeSet<BarcodeItem>>((arg0, arg1) -> arg0.compareTo((String)arg1));
        for (String element : barcodeModel.keySet()) {
            String key = element;
            if (!key.startsWith("10;")) continue;
            BarcodeItem item = barcodeModel.get(key);
            String mapKey = item.getIndex() + ";" + item.getCodeC();
            if (!allAnnexeH.containsKey(mapKey)) {
                allAnnexeH.put(mapKey, new TreeSet((arg0, arg1) -> arg0.getCode().compareTo(arg1.getCode())));
            }
            TreeSet<BarcodeItem> listForKey = allAnnexeH.get(mapKey);
            listForKey.add(item);
        }
        return allAnnexeH;
    }

    private static String generateAnnexeH() {
        StringBuilder buf = new StringBuilder();
        Map<String, TreeSet<BarcodeItem>> allAnnexeH = BarcodeHelper.getAllAnnexeHItems();
        buf.append(BarcodeHelper.generateTableBegin());
        Set<Map.Entry<String, TreeSet<BarcodeItem>>> entries = allAnnexeH.entrySet();
        for (Map.Entry<String, TreeSet<BarcodeItem>> entry : entries) {
            Set barcodeItems = entry.getValue();
            buf.append(BarcodeHelper.generateTableCellBegin());
            for (BarcodeItem barcodeItem : barcodeItems) {
                barcodeItem.setCode(barcodeItem.getCodeF() + "-0");
                buf.append(BarcodeHelper.generateFieldAnnexeH(barcodeItem));
            }
            buf.append(BarcodeHelper.generateTableCellEnd());
        }
        buf.append(BarcodeHelper.generateTableEnd());
        return buf.toString();
    }

    private static Map<Integer, List<BarcodeItem>> getSortedTableItemsForIdsAnnexeJ(@Nonnull List<String> ids) {
        ArrayList<BarcodeItem> toReturn = new ArrayList<BarcodeItem>();
        HashMap<Integer, List<BarcodeItem>> map = new HashMap<Integer, List<BarcodeItem>>();
        for (String id : ids) {
            toReturn.addAll(BarcodeHelper.getAllItemsForId(id));
        }
        for (int i = 0; i == ids.size(); ++i) {
            String id;
            id = ids.get(i - 1);
            map.put(i + 1, BarcodeHelper.getAllItemsForId(id));
        }
        long currentIndex = -1L;
        Collections.sort(toReturn);
        ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
        for (Object e : toReturn) {
            BarcodeItem item = (BarcodeItem)e;
            if (item.getIndex() / 100000L == currentIndex) {
                if (line == null) continue;
                line.add(item);
                continue;
            }
            if (!line.isEmpty()) {
                map.put((int)currentIndex, line);
            }
            currentIndex = item.getIndex() / 100000L;
            line = new ArrayList();
            line.add(item);
        }
        if (!line.isEmpty()) {
            map.put((int)currentIndex, line);
        }
        return map;
    }

    private static Map<Integer, List> getSortedTableItemsForIds(@Nonnull List<String> ids) {
        ArrayList<BarcodeItem> toReturn = new ArrayList<BarcodeItem>();
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (String id : ids) {
            toReturn.addAll(BarcodeHelper.getAllItemsForId(id));
        }
        for (int i = 0; i == ids.size(); ++i) {
            String id;
            id = ids.get(i - 1);
            map.put(i + 1, BarcodeHelper.getAllItemsForId(id));
        }
        int index = -1;
        int currentIndex = -1;
        Collections.sort(toReturn);
        ArrayList<BarcodeItem> line = null;
        for (Object e : toReturn) {
            BarcodeItem item = (BarcodeItem)e;
            if (item.getIndex().intValue() != currentIndex) {
                currentIndex = item.getIndex().intValue();
                if (line != null) {
                    map.put(++index, line);
                }
                line = new ArrayList<BarcodeItem>();
            }
            if (line == null) continue;
            line.add(item);
        }
        if (line != null) {
            map.put(++index, line);
        }
        return map;
    }

    private static List<BarcodeItem> getAllItemsForId(@Nonnull String id) {
        ArrayList<BarcodeItem> items = new ArrayList<BarcodeItem>();
        for (String element : barcodeModel.keySet()) {
            String key = element;
            if (!key.startsWith(id)) continue;
            items.add(barcodeModel.get(key));
        }
        return items;
    }

    private static List<BarcodeItem> getAllItemsForIdTableDefinitition(@Nonnull String id) {
        ArrayList<BarcodeItem> items = new ArrayList<BarcodeItem>();
        Iterator<String> iterator = barcodeModel.keySet().iterator();
        while (iterator.hasNext()) {
            String element;
            String key = element = iterator.next();
            StringTokenizer token = new StringTokenizer(key, ";");
            token.nextToken();
            if (!key.startsWith(id) || !token.hasMoreTokens()) continue;
            token.nextToken();
            String index = token.nextToken();
            if (!index.endsWith("90000")) continue;
            items.add(barcodeModel.get(key));
        }
        return items;
    }

    private static String generateBeginDoc() {
        StringBuilder buf = new StringBuilder();
        buf.append(XML_VERSION);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateBeginFile(@Nonnull String period, @Nonnull String date, @Nonnull String provider, @Nonnull String version, @Nonnull ReleaseMode releaseMode, @Nonnull Boolean hasAttachments) {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_DOC);
        buf.append(CRLF);
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_HEADER);
        buf.append(' ');
        buf.append(PERIOD);
        buf.append(QUOTE).append(period).append(QUOTE);
        buf.append(' ');
        buf.append(DATE_NOW);
        buf.append(QUOTE).append(date).append(QUOTE);
        buf.append(' ');
        buf.append(PROVIDER);
        buf.append(QUOTE).append(provider).append(QUOTE);
        buf.append(' ');
        buf.append(VERSION);
        if (releaseMode == ReleaseMode.PRINT) {
            buf.append(QUOTE).append(period).append(DASH).append(version).append(QUOTE);
        } else {
            if (releaseMode == ReleaseMode.SOUMISSION) {
                buf.append(QUOTE).append(version).append(DASH).append(VERSION_SOUMISSION);
            }
            if (releaseMode == ReleaseMode.DEPOT) {
                buf.append(QUOTE).append(version).append(DASH).append(VERSION_DEPOT);
            }
            if (hasAttachments.booleanValue()) {
                buf.append(DASH).append(VERSION_PIECEJOINTES);
            }
            buf.append(QUOTE);
            buf.append(' ');
            if (hasAttachments.booleanValue()) {
                buf.append(JUSTIF_ELECTRONIQUE).append(QUOTE).append("Y").append(QUOTE);
            } else {
                buf.append(JUSTIF_ELECTRONIQUE).append(QUOTE).append("N").append(QUOTE);
            }
        }
        buf.append(' ');
        buf.append(MODE).append(QUOTE).append(releaseMode.getVersionToken()).append(QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateBarcodeHeaderElements(@Nonnull String iddecla, @Nonnull String noContribuable, @Nonnull String city, @Nonnull String name, @Nonnull String addr, @Nonnull String zip, String typeApp) {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_DEF);
        buf.append(' ');
        buf.append("type=\"").append(typeApp).append(QUOTE).append(' ');
        buf.append(NAME);
        buf.append(QUOTE).append(name).append(QUOTE).append(' ');
        buf.append(ADDRESS);
        buf.append(QUOTE).append(addr).append(QUOTE).append(' ');
        buf.append(ZIP);
        buf.append(QUOTE).append(zip).append(QUOTE).append(' ');
        buf.append(CITY);
        buf.append(QUOTE).append(city).append(QUOTE).append(' ');
        buf.append(NO_CONTRIBUABLE);
        buf.append(QUOTE).append(noContribuable).append(QUOTE).append(' ');
        buf.append(ID_DECLA);
        buf.append(QUOTE).append(iddecla).append(QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateEndDoc() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_DOC);
        return buf.toString();
    }

    private static String generateBeginFormular(@Nonnull String formularId, @Nonnull String formularDesc) {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_FORMULAR_HEADER);
        buf.append(QUOTE).append(formularId).append(QUOTE).append(' ');
        buf.append(FORMULAR_DESC);
        buf.append(QUOTE).append(formularDesc).append(QUOTE);
        buf.append(END_LINE_TAG);
        buf.append(CRLF);
        buf.append(BEGIN_FORMULAR_DATA);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateEndFormular() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_FORMULAR_DATA);
        buf.append(CRLF);
        buf.append(END_FORMULAR_HEADER);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableBegin() {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableEnd() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableCellBegin() {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_TABLE_CELL);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableCellEnd() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_TABLE_CELL);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateField(@Nonnull BarcodeItem item) {
        StringBuilder buf = new StringBuilder();
        if (item.isToWrite()) {
            buf.append(BEGIN_FIELD);
            buf.append(QUOTE).append(item.getCodeF()).append(QUOTE);
            buf.append(' ');
            buf.append(CODE);
            buf.append(QUOTE).append(item.getCodeC()).append(QUOTE);
            buf.append(' ');
            buf.append(MODIFIED);
            String modified = item.isWarning() ? "1" : "0";
            buf.append(QUOTE).append(modified).append(QUOTE);
            buf.append(' ');
            buf.append(VALUE);
            buf.append(QUOTE).append(item.getValue()).append(QUOTE);
            buf.append(END_TAG);
            buf.append(CRLF);
        }
        return buf.toString();
    }

    private static String generateFieldAnnexeH(@Nonnull BarcodeItem item) {
        int codeC = Integer.parseInt(item.getCodeC());
        StringBuilder buf = new StringBuilder();
        if (item.isToWrite()) {
            buf.append(BEGIN_FIELD);
            buf.append(QUOTE).append(item.getCodeF()).append(QUOTE);
            buf.append(' ');
            buf.append(CODE);
            buf.append(QUOTE).append(codeC).append(QUOTE);
            buf.append(' ');
            buf.append(MODIFIED);
            String modified = item.isWarning() ? "1" : "0";
            buf.append(QUOTE).append(modified).append(QUOTE);
            buf.append(' ');
            buf.append(VALUE);
            buf.append(QUOTE).append(item.getValue()).append(QUOTE);
            buf.append(END_TAG);
            buf.append(CRLF);
        }
        return buf.toString();
    }

    private static String generateFieldAnnexeJK(@Nonnull BarcodeItem item) {
        String indexStr = item.getIndex() != null ? String.valueOf(item.getIndex()) : "0";
        int codeC = Integer.parseInt(item.getCodeC());
        int length = indexStr.length();
        int indexCanton = Integer.parseInt(indexStr.substring(length - 1, length)) * 5;
        codeC += indexCanton;
        StringBuilder buf = new StringBuilder();
        if (item.isToWrite()) {
            buf.append(BEGIN_FIELD);
            buf.append(QUOTE).append(item.getCodeF()).append(QUOTE);
            buf.append(' ');
            buf.append(CODE);
            buf.append(QUOTE).append(codeC).append(QUOTE);
            buf.append(' ');
            buf.append(MODIFIED);
            String modified = item.isWarning() ? "1" : "0";
            buf.append(QUOTE).append(modified).append(QUOTE);
            buf.append(' ');
            buf.append(VALUE);
            buf.append(QUOTE).append(item.getValue()).append(QUOTE);
            buf.append(END_TAG);
            buf.append(CRLF);
        }
        return buf.toString();
    }

    private static void generateTable(@Nonnull StringBuffer buf, @Nonnull BufferedReader reader) throws IOException {
        Map<Integer, List> barcodeTableItems;
        ArrayList<String> ids = new ArrayList<String>();
        String lineInTable = reader.readLine();
        if (lineInTable != null) {
            while (!END_TABLE_ROW.equals(lineInTable)) {
                ids.add(lineInTable);
                lineInTable = reader.readLine();
            }
        }
        if (!(barcodeTableItems = BarcodeHelper.getSortedTableItemsForIds(ids)).isEmpty()) {
            buf.append(BarcodeHelper.generateTableBegin());
            int numberOfLine = barcodeTableItems.keySet().size();
            for (int j = 0; j < numberOfLine; ++j) {
                buf.append(BarcodeHelper.generateTableCellBegin());
                List itemsForThisLine = barcodeTableItems.get(j);
                for (Object anItemsForThisLine : itemsForThisLine) {
                    BarcodeItem item = (BarcodeItem)anItemsForThisLine;
                    buf.append(BarcodeHelper.generateField(item));
                }
                buf.append(BarcodeHelper.generateTableCellEnd());
            }
            buf.append(BarcodeHelper.generateTableEnd());
        }
    }

    private static void generateEntries(@Nonnull int indexLine, @Nonnull Map<Integer, List<BarcodeItem>> barcodeTableItems, @Nonnull StringBuffer buf) {
        List<BarcodeItem> itemsForThisLine = barcodeTableItems.get(indexLine);
        if (itemsForThisLine != null && itemsForThisLine.size() > 0) {
            for (BarcodeItem item : itemsForThisLine) {
                buf.append(BarcodeHelper.generateFieldAnnexeJK(item));
            }
        }
    }

    private static void generateDefinition(@Nonnull int indexLine, @Nonnull int maxNumberOfInput, @Nonnull List<BarcodeItem> allItemsForIdDefinition, @Nonnull StringBuffer buf) {
        for (int i = 0; i < maxNumberOfInput; ++i) {
            int index = indexLine * maxNumberOfInput + i;
            if (allItemsForIdDefinition.size() <= index) continue;
            BarcodeItem item = allItemsForIdDefinition.get(index);
            buf.append(BarcodeHelper.generateFieldAnnexeJK(item));
        }
    }
}

