/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;

public class CFTauxAnnexeG
implements CalcItem {
    private final DataResource dataResource;

    public CFTauxAnnexeG(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        String configKey = StackUtil.getString((FastStack)stack);
        long numberOfDaysThisYear = StackUtil.getLong((FastStack)stack);
        long numberOfDaysYearMinus1 = StackUtil.getLong((FastStack)stack);
        long numberOfDaysYearMinus2 = StackUtil.getLong((FastStack)stack);
        long numberOfDaysBusinessYear = StackUtil.getLong((FastStack)stack);
        if (numberOfDaysBusinessYear == 0L) {
            stack.push((Object)0.0);
            return;
        }
        BigDecimal interestRate = this.getPonderedInterestRate("tauxAnnexeG", configKey, numberOfDaysThisYear);
        interestRate = interestRate.add(this.getPonderedInterestRate("tauxAnnexeGYearMinus1", configKey, numberOfDaysYearMinus1));
        interestRate = interestRate.add(this.getPonderedInterestRate("tauxAnnexeGYearMinus2", configKey, numberOfDaysYearMinus2));
        interestRate = interestRate.divide(BigDecimal.valueOf(numberOfDaysBusinessYear), MathContext.DECIMAL64);
        stack.push((Object)interestRate.doubleValue());
    }

    private BigDecimal getPonderedInterestRate(String resourceName, String configKey, long numberOfDays) {
        Map resourceMap = this.dataResource.get(resourceName, null, null);
        BigDecimal interestRate = (BigDecimal)resourceMap.get(configKey);
        return interestRate.multiply(BigDecimal.valueOf(numberOfDays));
    }
}

