/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.BaremeImpotDTO;
import java.util.Map;

public class CFBaremeImpot
implements CalcItem {
    private final DataResource dataResource;

    public CFBaremeImpot(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        double montant = 0.0;
        Object montantObj = stack.pop();
        if (montantObj instanceof Number) {
            montant = ((Number)montantObj).doubleValue();
        }
        String filename = stack.pop().toString();
        double impot = this.getImpotPourMontant(montant, filename);
        stack.push((Object)impot);
    }

    private double getImpotPourMontant(double montant, String filename) {
        double totalImpot = 0.0;
        Map baremes = this.dataResource.get(filename, null, null);
        BaremeImpotDTO hauptTranche = null;
        BaremeImpotDTO restTranche = null;
        for (Object o : baremes.values()) {
            BaremeImpotDTO tranche = (BaremeImpotDTO)o;
            if (tranche.getEndTranche() > montant) {
                restTranche = tranche;
                break;
            }
            hauptTranche = tranche;
            restTranche = tranche;
        }
        double anteilRestTranche = restTranche != null ? montant - restTranche.getStartTranche() : montant;
        if (hauptTranche != null) {
            totalImpot = hauptTranche.getImpot();
        }
        if (anteilRestTranche > 0.0) {
            totalImpot = restTranche != null ? (totalImpot += anteilRestTranche * restTranche.getTaux()) : (totalImpot += anteilRestTranche);
        }
        return totalImpot;
    }
}

