/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializationUtils {
    public static void serialize(Serializable object, OutputStream outputStream) throws IOException {
        try (ObjectOutputStream out = null;){
            out = new ObjectOutputStream(outputStream);
            out.writeObject(object);
        }
    }

    public static void serializeToFile(Serializable object, String fileName) throws IOException {
        OutputStream outputStream = FileUtils.getOutputStream(fileName);
        SerializationUtils.serialize(object, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserialize(InputStream inputStream) throws Throwable {
        try (ObjectInputStream in = null;){
            Object obj;
            in = new ObjectInputStream(inputStream);
            Object object = obj = in.readObject();
            return (T)object;
        }
    }

    public static <T> T deserializeFromFile(String fileName) throws Throwable {
        InputStream inputStream = FileUtils.getInputStream(fileName);
        return SerializationUtils.deserialize(inputStream);
    }

    public static <T> T deepCopy(Serializable object) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedOutputStream buffered = new BufferedOutputStream(outputStream);
        try {
            SerializationUtils.serialize(object, buffered);
            return SerializationUtils.deserialize(new BufferedInputStream(new ByteArrayInputStream(outputStream.toByteArray())));
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed in performing a deep copy", e);
        }
    }
}

