/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.distributed.JamonDataPersister;
import com.jamonapi.distributed.JamonDataPersisterFactory;
import com.jamonapi.distributed.LocalJamonDataPersister;
import com.jamonapi.utils.FileUtils;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class JamonDataPersisterDecorator
implements JamonDataPersister {
    private LocalJamonDataPersister localJamonData;
    private JamonDataPersister jamonDataPersister;
    private Properties jamonProperties;

    public JamonDataPersisterDecorator() {
        this(null, new LocalJamonDataPersister());
    }

    JamonDataPersisterDecorator(JamonDataPersister persister, LocalJamonDataPersister localJamonData) {
        this.jamonDataPersister = persister;
        this.localJamonData = localJamonData;
        this.jamonProperties = JamonDataPersisterFactory.getJamonProperties();
    }

    @Override
    public Set<String> getInstances() {
        TreeSet<String> allInstances = new TreeSet<String>(this.localJamonData.getInstances());
        allInstances.addAll(this.getDecoratedInstances());
        return allInstances;
    }

    @Override
    public void put() {
        this.localJamonData.put();
        this.put(this.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String instanceKey) {
        Monitor mon = MonitorFactory.getTimeMonitor(this.getJamonLabel(".put()"));
        if (mon.getActive() < 1.0) {
            mon.start();
            try {
                if (instanceKey != null) {
                    this.jamonDataPersister.put(instanceKey);
                }
            }
            catch (Throwable t) {
                MonitorFactory.addException(mon, t);
            }
            finally {
                mon.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorComposite get(String key) {
        MonitorComposite monitorComposite = this.localJamonData.get(key);
        if (monitorComposite == null) {
            Monitor mon = MonitorFactory.start(this.getJamonLabel(".get()"));
            try {
                monitorComposite = this.jamonDataPersister.get(key);
            }
            catch (Throwable t) {
                MonitorFactory.addException(mon, t);
                MonitorComposite monitorComposite2 = this.localJamonData.get("local");
                return monitorComposite2;
            }
            finally {
                mon.stop();
            }
        }
        return monitorComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String instanceKey) {
        this.localJamonData.remove(instanceKey);
        Monitor mon = MonitorFactory.start(this.getJamonLabel(".remove()"));
        try {
            this.jamonDataPersister.remove(instanceKey);
        }
        catch (Throwable t) {
            MonitorFactory.addException(mon, t);
        }
        finally {
            mon.stop();
        }
    }

    @Override
    public String getInstance() {
        try {
            String prefix = this.jamonProperties.getProperty("jamonDataPersister.label.prefix");
            String label = this.jamonProperties.getProperty("jamonDataPersister.label");
            if ("".equals(label)) {
                label = this.jamonDataPersister.getInstance();
            }
            return FileUtils.makeValidFileName(prefix + label);
        }
        catch (Throwable t) {
            MonitorFactory.addException(t);
            return null;
        }
    }

    public JamonDataPersister getJamonDataPersister() {
        return this.jamonDataPersister;
    }

    private Set<String> getDecoratedInstances() {
        try {
            return this.jamonDataPersister.getInstances();
        }
        catch (Throwable e) {
            MonitorFactory.addException(e);
            HashSet<String> error = new HashSet<String>();
            error.add("ExceptionThrown");
            return error;
        }
    }

    private String getJamonLabel(String name) {
        return this.getClass().getCanonicalName() + name;
    }
}

