/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ResourceNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RefParser
implements ElementParser {
    public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!elementName.equals("ref")) {
            throw new ElementParserException("null-parser can not handle elements with the name=" + elementName);
        }
        String objectId = element.getAttribute("id");
        if (objectId == null || objectId.equals("")) {
            throw new ElementParserException("id of ref tag must be the name of a xml-file");
        }
        try {
            InputStream ins = factory.getResourceLocator().getResourceAsStream(objectId);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(ins);
            Element root = new Element(doc.getDocumentElement());
            ClassObjectPair cop = factory.getParser(root.getNodeName()).parse(root, factory);
            return cop;
        }
        catch (SAXException ex) {
            throw new ElementParserException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (IOException ex) {
            throw new ElementParserException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ElementParserException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException("no parser found", ex);
        }
        catch (ResourceNotFoundException ex) {
            throw new ElementParserException("ref parser: resource not foung", ex);
        }
    }
}

