/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ArrayParser;
import ch.dvbern.lib.resource.construct.xml.CastParser;
import ch.dvbern.lib.resource.construct.xml.ClassLoaderResourceLocator;
import ch.dvbern.lib.resource.construct.xml.ClassParser;
import ch.dvbern.lib.resource.construct.xml.ConstructParser;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.GetFieldParser;
import ch.dvbern.lib.resource.construct.xml.InvokeParser;
import ch.dvbern.lib.resource.construct.xml.NullParser;
import ch.dvbern.lib.resource.construct.xml.ParserAlreadyRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.lib.resource.construct.xml.PrimParser;
import ch.dvbern.lib.resource.construct.xml.RefParser;
import ch.dvbern.lib.resource.construct.xml.ResourceLocator;
import ch.dvbern.lib.resource.construct.xml.ScriptParser;
import ch.dvbern.lib.resource.construct.xml.SetFieldParser;
import ch.dvbern.lib.resource.construct.xml.VarParser;
import ch.dvbern.lib.resource.construct.xml.VardefParser;
import java.util.HashMap;
import java.util.Map;

public class ParserFactory {
    private Map parsers = new HashMap();
    private ResourceLocator locator;

    public ParserFactory() {
        this(new ClassLoaderResourceLocator());
    }

    public ParserFactory(ResourceLocator locator) {
        if (locator == null) {
            throw new IllegalArgumentException("locator must not be null");
        }
        this.locator = locator;
        this.init();
    }

    private void init() {
        this.parsers.put("ref", new RefParser());
        this.parsers.put("construct", new ConstructParser());
        this.parsers.put("array", new ArrayParser());
        this.parsers.put("short", new PrimParser());
        this.parsers.put("null", new NullParser());
        this.parsers.put("cast", new CastParser());
        this.parsers.put("class", new ClassParser());
        this.parsers.put("invoke", new InvokeParser());
        this.parsers.put("setfield", new SetFieldParser());
        this.parsers.put("getfield", new GetFieldParser());
        this.parsers.put("script", new ScriptParser());
        this.parsers.put("vardef", new VardefParser());
        this.parsers.put("var", new VarParser());
        PrimParser prim = new PrimParser();
        this.parsers.put("int", prim);
        this.parsers.put("short", prim);
        this.parsers.put("long", prim);
        this.parsers.put("float", prim);
        this.parsers.put("double", prim);
        this.parsers.put("char", prim);
        this.parsers.put("boolean", prim);
        this.parsers.put("string", prim);
    }

    public ElementParser getParser(String elementName) throws ParserNotRegisteredException {
        String lowerCaseName = elementName.toLowerCase();
        ElementParser parser = (ElementParser)this.parsers.get(lowerCaseName);
        if (parser == null) {
            throw new ParserNotRegisteredException("there is no parser registered for elementName=" + lowerCaseName);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerParser(String elementName, ElementParser parser) throws ParserAlreadyRegisteredException {
        String lowerCaseName = elementName.toLowerCase();
        Map map = this.parsers;
        synchronized (map) {
            if (this.parsers.containsKey(lowerCaseName)) {
                throw new ParserAlreadyRegisteredException("there is already a parser registered for elementName=" + lowerCaseName);
            }
            this.parsers.put(lowerCaseName, parser);
        }
    }

    public ResourceLocator getResourceLocator() {
        return this.locator;
    }
}

