/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class InvokeParser
implements ElementParser {
    public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
        String methodName = element.getAttribute("methodName");
        List objectElChildren = element.getElementsByTagName("target");
        if (objectElChildren.size() != 1) {
            throw new ElementParserException("object must have exactly on child (construct or ref or cast...)");
        }
        Element objectElToParse = (Element)objectElChildren.get(0);
        Object myObject = null;
        Class myClass = null;
        try {
            ClassObjectPair cop = factory.getParser(objectElToParse.getNodeName()).parse(objectElToParse, factory);
            myObject = cop.getObject();
            myClass = cop.getKlass();
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException(ex);
        }
        List parameterElList = element.getElementsByTagName("parameters");
        Class[] classArray = null;
        Object[] objArray = null;
        if (parameterElList != null) {
            classArray = new Class[parameterElList.size()];
            objArray = new Object[parameterElList.size()];
            for (int i = 0; i < parameterElList.size(); ++i) {
                Element paramEl = (Element)parameterElList.get(i);
                try {
                    ClassObjectPair cop = factory.getParser(paramEl.getNodeName()).parse(paramEl, factory);
                    classArray[i] = cop.getKlass();
                    objArray[i] = cop.getObject();
                    continue;
                }
                catch (ParserNotRegisteredException ex) {
                    throw new ElementParserException(ex);
                }
            }
        }
        try {
            Method method = myClass.getMethod(methodName, classArray);
            Object obj = method.invoke(myObject, objArray);
            if (obj == null) {
                return new ClassObjectPair(null, null);
            }
            return new ClassObjectPair(obj.getClass(), obj);
        }
        catch (NoSuchMethodException ex) {
            throw new ElementParserException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ElementParserException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ElementParserException(ex);
        }
    }
}

