/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Construct;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import java.util.ArrayList;
import java.util.List;

public class ConstructParser
implements ElementParser {
    public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
        ClassObjectPair retVal = null;
        String className = element.getAttribute("class");
        Class klass = null;
        try {
            klass = ClassFactory.getKlass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("classLoader could NOT load class for name=" + className, ex);
        }
        List argChildren = element.getChildElements();
        ArrayList<Class> argClasses = new ArrayList<Class>(argChildren.size());
        ArrayList<Object> initArgs = new ArrayList<Object>(argChildren.size());
        for (int i = 0; i < argChildren.size(); ++i) {
            Element el = (Element)argChildren.get(i);
            try {
                ClassObjectPair cop = factory.getParser(el.getNodeName()).parse(el, factory);
                argClasses.add(cop.getKlass());
                initArgs.add(cop.getObject());
                continue;
            }
            catch (ParserNotRegisteredException ex) {
                throw new ElementParserException("no parser found for element name=" + el.getNodeName(), ex);
            }
        }
        Construct construct = new Construct(klass, argClasses.toArray(new Class[0]), initArgs.toArray(new Object[0]));
        try {
            retVal = new ClassObjectPair(construct.getKlass(), construct.getObject());
        }
        catch (ConstructionException ex) {
            throw new ElementParserException(ex);
        }
        return retVal;
    }
}

