/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

final class TermScorer
extends Scorer {
    private TermDocs termDocs;
    private byte[] norms;
    private float weight;
    private int doc;
    private final int[] docs = new int[128];
    private final int[] freqs = new int[128];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private float[] scoreCache = new float[32];

    TermScorer(TermDocs termDocs, byte[] byArray, float f) throws IOException {
        this.termDocs = termDocs;
        this.norms = byArray;
        this.weight = f;
        int n = 0;
        while (n < 32) {
            this.scoreCache[n] = Similarity.tf(n) * this.weight;
            ++n;
        }
        this.pointerMax = this.termDocs.read(this.docs, this.freqs);
        if (this.pointerMax != 0) {
            this.doc = this.docs[0];
        } else {
            this.termDocs.close();
            this.doc = Integer.MAX_VALUE;
        }
    }

    final void score(HitCollector hitCollector, int n) throws IOException {
        int n2 = this.doc;
        while (n2 < n) {
            int n3 = this.freqs[this.pointer];
            float f = n3 < 32 ? this.scoreCache[n3] : Similarity.tf(n3) * this.weight;
            hitCollector.collect(n2, f *= Similarity.norm(this.norms[n2]));
            if (++this.pointer == this.pointerMax) {
                this.pointerMax = this.termDocs.read(this.docs, this.freqs);
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.termDocs.close();
                    this.doc = Integer.MAX_VALUE;
                    return;
                }
            }
            n2 = this.docs[this.pointer];
        }
        this.doc = n2;
    }
}

