/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermScorer;

public final class TermQuery
extends Query {
    private Term term;
    private float idf = 0.0f;
    private float weight = 0.0f;

    public TermQuery(Term term) {
        this.term = term;
    }

    final float sumOfSquaredWeights(Searcher searcher) throws IOException {
        this.idf = Similarity.idf(this.term, searcher);
        this.weight = this.idf * this.boost;
        return this.weight * this.weight;
    }

    final void normalize(float f) {
        this.weight *= f;
        this.weight *= this.idf;
    }

    Scorer scorer(IndexReader indexReader) throws IOException {
        TermDocs termDocs = indexReader.termDocs(this.term);
        if (termDocs == null) {
            return null;
        }
        return new TermScorer(termDocs, indexReader.norms(this.term.field()), this.weight);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.term.field().equals(string)) {
            stringBuffer.append(this.term.field());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.term.text());
        if (this.boost != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.boost));
        }
        return stringBuffer.toString();
    }
}

