/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.product.SoftwareVersion;

public class SoftwareObjectKey
implements Cloneable {
    private String uid = "";
    private SoftwareVersion version = new SoftwareVersion();
    private int instance = 0;

    public Object clone() {
        SoftwareObjectKey softwareObjectKey = new SoftwareObjectKey();
        softwareObjectKey.setUID(this.uid);
        softwareObjectKey.setVersion((SoftwareVersion)this.version.clone());
        softwareObjectKey.setInstance(this.instance);
        return softwareObjectKey;
    }

    public int hashCode() {
        int n = this.uid.hashCode() + this.version.hashCode();
        Integer n2 = new Integer(n);
        return n2.hashCode();
    }

    public void setUID(String string) {
        this.uid = string;
    }

    public String getUID() {
        return this.uid;
    }

    public void setVersion(SoftwareVersion softwareVersion) {
        this.version = softwareVersion;
    }

    public SoftwareVersion getVersion() {
        return this.version;
    }

    public void setInstance(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("instance cannot be negative");
        }
        this.instance = n;
    }

    public int getInstance() {
        return this.instance;
    }

    public void copyFrom(SoftwareObjectKey softwareObjectKey) {
        this.setUID(softwareObjectKey.getUID());
        this.setVersion((SoftwareVersion)softwareObjectKey.getVersion().clone());
        this.setInstance(softwareObjectKey.getInstance());
    }

    public boolean equalsWithInstance(Object object) {
        SoftwareObjectKey softwareObjectKey;
        boolean bl = false;
        if (object instanceof SoftwareObjectKey && this.equals(softwareObjectKey = (SoftwareObjectKey)object) && this.instance == softwareObjectKey.instance) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SoftwareObjectKey) {
            SoftwareObjectKey softwareObjectKey = (SoftwareObjectKey)object;
            if (this.uid.equals(softwareObjectKey.uid) && this.version.equals(softwareObjectKey.version)) {
                bl = true;
            }
        }
        return bl;
    }

    public int compareTo(SoftwareObjectKey softwareObjectKey) throws Exception {
        return this.compareTo(softwareObjectKey, SoftwareVersion.COMPARISON_DEPTH_UPDATE);
    }

    public int compareTo(SoftwareObjectKey softwareObjectKey, int n) throws Exception {
        if (!softwareObjectKey.uid.equals(this.uid)) {
            throw new Exception("Invalid comparison: key UID values are not the same");
        }
        int n2 = this.version.compareTo(softwareObjectKey.version, n);
        if (n2 == 0) {
            n2 = this.instance - softwareObjectKey.instance;
        }
        return n2;
    }

    public String toString() {
        return "uid = " + this.uid + " : version = " + this.version.toString() + " : instance = " + this.instance;
    }
}

