/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.IProgressListener;
import ch.dvbern.lib.update.exception.CommunicationException;
import ch.dvbern.lib.update.exception.UpdateFailureException;
import ch.dvbern.lib.update.type.DownloadItem;
import ch.dvbern.lib.update.type.DownloadItemList;
import ch.dvbern.lib.update.type.ProxyConfig;
import ch.dvbern.lib.update.type.UpdateConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateManager {
    private static final int BUFFER_SIZE = 4096;
    private static final String VERSION_FILE = "version.xml";
    private UpdateConfig updateConfig;
    private ProxyConfig proxyConfig;
    private List progressListeners = new ArrayList();
    private String localVersion;
    private String remoteVersion;
    private boolean canceled = false;

    public UpdateManager(UpdateConfig updateConfig, ProxyConfig proxyConfig) {
        this.updateConfig = updateConfig;
        this.proxyConfig = proxyConfig;
        this.configureProxy();
    }

    public UpdateManager(UpdateConfig updateConfig) {
        this(updateConfig, null);
    }

    public boolean isUpdateAvailable() throws UpdateFailureException, CommunicationException {
        return !this.getRemoteVersion().equalsIgnoreCase(this.getLocalVersion());
    }

    public void update() throws UpdateFailureException, CommunicationException {
        if (this.isUpdateAvailable()) {
            DownloadItemList downloadItemList = new DownloadItemList();
            boolean start = false;
            try {
                boolean result;
                DownloadItem file;
                int i;
                URL url = new URL(this.updateConfig.getProtocol() + "://" + this.updateConfig.getServer() + ":" + String.valueOf(this.updateConfig.getPort()) + this.updateConfig.getPath() + VERSION_FILE);
                InputStream is = url.openStream();
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                NodeList versionNodes = doc.getChildNodes().item(0).getChildNodes();
                for (int i2 = 0; i2 < versionNodes.getLength(); ++i2) {
                    Node versionNodeNumber;
                    String version;
                    Node versionNode = versionNodes.item(i2);
                    if (!versionNode.getNodeName().equals("version") || !(version = (versionNodeNumber = versionNode.getAttributes().getNamedItem("description")).getNodeValue()).equalsIgnoreCase(this.getLocalVersion()) && !start) continue;
                    if (version.equalsIgnoreCase(this.getLocalVersion()) && !start) {
                        start = true;
                        continue;
                    }
                    if (!version.equalsIgnoreCase(this.getLocalVersion()) && start) {
                        NodeList nodes = versionNode.getChildNodes();
                        for (int j = 0; j < nodes.getLength(); ++j) {
                            Node libNode = nodes.item(j);
                            if (!libNode.getNodeName().equals("file")) continue;
                            NodeList libSubNodes = libNode.getChildNodes();
                            String fileName = "";
                            String location = "";
                            int size = -1;
                            String os = "all";
                            String desc = "";
                            for (int k = 0; k < libSubNodes.getLength(); ++k) {
                                Node node = libSubNodes.item(k);
                                if (node.getNodeName().equals("name") && node.getChildNodes().item(0) != null) {
                                    fileName = node.getChildNodes().item(0).getNodeValue();
                                    continue;
                                }
                                if (node.getNodeName().equals("location") && node.getChildNodes().item(0) != null) {
                                    location = node.getChildNodes().item(0).getNodeValue();
                                    continue;
                                }
                                if (node.getNodeName().equals("size") && node.getChildNodes().item(0) != null) {
                                    size = Integer.parseInt(node.getChildNodes().item(0).getNodeValue());
                                    continue;
                                }
                                if (node.getNodeName().equals("os") && node.getChildNodes().item(0) != null) {
                                    os = node.getChildNodes().item(0).getNodeValue();
                                    continue;
                                }
                                if (!node.getNodeName().equals("desc") || node.getChildNodes().item(0) == null) continue;
                                desc = node.getChildNodes().item(0).getNodeValue();
                            }
                            DownloadItem downloadItem = new DownloadItem(version, fileName, location, size, os, desc);
                            if (!this.correctOperatingSystem(os)) continue;
                            downloadItemList.addDownloadItem(downloadItem);
                        }
                        continue;
                    }
                    System.err.println("ERROR occured in UpdateManager.update() that should not happen.");
                }
                is.close();
                List filesToDownload = downloadItemList.getDownloadItems();
                long totalSize = 0L;
                long downloadedSize = 0L;
                for (i = 0; i < filesToDownload.size(); ++i) {
                    file = (DownloadItem)filesToDownload.get(i);
                    totalSize += file.getSize();
                }
                for (i = 0; i < filesToDownload.size() && !this.canceled; ++i) {
                    file = (DownloadItem)filesToDownload.get(i);
                    this.download(file, downloadedSize, totalSize);
                    this.updateProgress((int)(100.0f * (float)(downloadedSize += file.getSize()) / (float)totalSize));
                }
                if (this.canceled) {
                    this.updateCancelled();
                    return;
                }
                File progressDir = new File("version_update_progress");
                File completeDir = new File("version_update_complete");
                if (completeDir.exists()) {
                    this.deleteDirectory(completeDir);
                }
                boolean bl = result = !progressDir.exists() || progressDir.renameTo(completeDir);
                if (result) {
                    this.updateFinished();
                }
            }
            catch (MalformedURLException e) {
                throw new UpdateFailureException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new CommunicationException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new UpdateFailureException("Error while parsing remote version file occured", e);
            }
            catch (ParserConfigurationException e) {
                throw new UpdateFailureException("Error while parsing remote version file occured", e);
            }
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    public void reset() {
        this.localVersion = null;
        this.remoteVersion = null;
        this.canceled = false;
    }

    private boolean correctOperatingSystem(String os) {
        String realOs = System.getProperty("os.name");
        if (os.trim().equals("") || os.trim().toLowerCase().startsWith("all")) {
            return true;
        }
        if (realOs.startsWith("Windows") && os.toLowerCase().startsWith("win")) {
            return true;
        }
        if (realOs.startsWith("Linux") && os.toLowerCase().startsWith("linux")) {
            return true;
        }
        return realOs.startsWith("Mac OS X") && os.toLowerCase().startsWith("mac");
    }

    public void addProgressListener(IProgressListener l) {
        this.progressListeners.add(l);
    }

    public void removeProgressListener(IProgressListener l) {
        this.progressListeners.remove(l);
    }

    private void updateProgress(String resource) {
        Iterator iterator = this.progressListeners.iterator();
        while (iterator.hasNext()) {
            IProgressListener listener = (IProgressListener)iterator.next();
            listener.updateProgress(resource);
        }
    }

    private void updateProgress(int percent) {
        Iterator iterator = this.progressListeners.iterator();
        while (iterator.hasNext()) {
            IProgressListener listener = (IProgressListener)iterator.next();
            listener.updateProgress(percent);
        }
    }

    private void updateFinished() {
        Iterator iterator = this.progressListeners.iterator();
        while (iterator.hasNext()) {
            IProgressListener listener = (IProgressListener)iterator.next();
            listener.updateFinished();
        }
    }

    private void updateCancelled() {
        Iterator iterator = this.progressListeners.iterator();
        while (iterator.hasNext()) {
            IProgressListener listener = (IProgressListener)iterator.next();
            listener.updateCancelled();
        }
    }

    private void configureProxy() {
        if (this.proxyConfig != null) {
            if (this.proxyConfig.isProxyAvailable() && !this.proxyConfig.getHost().equals("")) {
                System.setProperty("proxySet", Boolean.TRUE.toString());
                System.setProperty("http.proxyHost", this.proxyConfig.getHost());
                System.setProperty("http.proxyPort", String.valueOf(this.proxyConfig.getPort()));
                if (this.proxyConfig.getAuthenticator() != null) {
                    Authenticator.setDefault(this.proxyConfig.getAuthenticator());
                } else {
                    Authenticator.setDefault(null);
                }
            } else {
                System.getProperties().remove("proxySet");
                System.getProperties().remove("http.proxyHost");
                System.getProperties().remove("http.proxyPort");
                Authenticator.setDefault(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLocalVersion() throws UpdateFailureException {
        if (this.localVersion != null) return this.localVersion;
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader("version.txt"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String searchString;
                    if (!(line = line.trim().toLowerCase()).startsWith(searchString = "version=")) continue;
                    this.localVersion = line.substring(searchString.length()).trim();
                }
                Object var5_5 = null;
                if (reader == null) return this.localVersion;
            }
            catch (IOException e) {
                throw new UpdateFailureException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        reader.close();
        return this.localVersion;
    }

    private String getRemoteVersion() throws UpdateFailureException, CommunicationException {
        if (this.remoteVersion == null) {
            try {
                URL url = new URL(this.updateConfig.getProtocol() + "://" + this.updateConfig.getServer() + ":" + String.valueOf(this.updateConfig.getPort()) + this.updateConfig.getPath() + VERSION_FILE);
                InputStream is = url.openStream();
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                NodeList versionNodes = doc.getChildNodes().item(0).getChildNodes();
                for (int i = 0; i < versionNodes.getLength(); ++i) {
                    Node versionNode = versionNodes.item(i);
                    if (!versionNode.getNodeName().equals("version")) continue;
                    this.remoteVersion = versionNode.getAttributes().getNamedItem("description").getNodeValue();
                }
                is.close();
            }
            catch (MalformedURLException e) {
                throw new UpdateFailureException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new CommunicationException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new UpdateFailureException("Error while parsing remote version file occured", e);
            }
            catch (ParserConfigurationException e) {
                throw new UpdateFailureException("Error while parsing remote version file occured", e);
            }
        }
        return this.remoteVersion;
    }

    private void download(DownloadItem downloadItem, long downloadedSize, long totalSize) throws MalformedURLException, IOException {
        URL url = new URL(this.updateConfig.getProtocol() + "://" + this.updateConfig.getServer() + ":" + String.valueOf(this.updateConfig.getPort()) + this.updateConfig.getPath() + UpdateManager.urlEncode(downloadItem.getVersion()) + "/" + downloadItem.getLocation() + UpdateManager.urlEncode(downloadItem.getFileName()));
        String resource = downloadItem.getLocation() + downloadItem.getFileName();
        File locationDir = new File("version_update_progress/" + downloadItem.getLocation());
        if (!locationDir.exists()) {
            locationDir.mkdirs();
        }
        File file = new File("version_update_progress/" + resource);
        this.updateProgress(downloadItem.getDescription());
        this.download(url, file, downloadedSize, totalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(URL source, File target, long downloadedSize, long totalSize) throws IOException {
        IOException e22;
        FileOutputStream os;
        block12: {
            InputStream is = null;
            os = null;
            try {
                URLConnection urlConnection = source.openConnection();
                urlConnection.setAllowUserInteraction(false);
                urlConnection.setUseCaches(false);
                urlConnection.connect();
                is = urlConnection.getInputStream();
                os = new FileOutputStream(target);
                byte[] buffer = new byte[4096];
                int totalBytesRead = 0;
                int bytesRead = -1;
                while ((bytesRead = is.read(buffer)) != -1 && !this.canceled) {
                    os.write(buffer, 0, bytesRead);
                    this.updateProgress((int)(100.0f * (float)((long)(totalBytesRead += bytesRead) + downloadedSize) / (float)totalSize));
                }
                Object var14_11 = null;
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var14_12 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e22) {}
        }
    }

    private void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectory(files[i]);
            }
            files[i].delete();
        }
        directory.delete();
    }

    private static String urlEncode(String str) throws IOException {
        return str.replaceAll(" ", "%20");
    }
}

