/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.player;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.JavawsFactory;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import com.sun.javaws.ui.player.EntryManager;
import com.sun.javaws.ui.player.JNLEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HTMLEntryManager
extends EntryManager {
    private ArrayList _entries = new ArrayList();
    private URL _url;
    private boolean _loading;
    private CallbackHandler _handler;
    private static final int MAX_T_COUNT = 5;

    public int getState() {
        return this._loading ? 1 : 0;
    }

    public int size() {
        return this._entries.size();
    }

    public HTMLEntryManager() {
        try {
            String string = ConfigProperties.getInstance().getRemoteURL();
            if (string != null) {
                this._url = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishedLoadingJNLFiles() {
        if (Globals.TraceHTMLEntryParsing) {
            Debug.println("Finished loading remote JNL files");
        }
        HTMLEntryManager hTMLEntryManager = this;
        synchronized (hTMLEntryManager) {
            this._loading = false;
        }
        SwingUtilities.invokeLater(new Runnable(this){
            private final HTMLEntryManager this$0;

            public void run() {
                this.this$0.firePropertyChange("state", new Integer(1), new Integer(0));
            }
            {
                this.this$0 = hTMLEntryManager;
            }
        });
    }

    private void parseURL() {
        InputStream inputStream;
        block9: {
            inputStream = null;
            if (Globals.TraceHTMLEntryParsing) {
                Debug.println("starting jnl file loading from: " + this._url);
            }
            this._handler = new CallbackHandler(this);
            if (this._url.toString().endsWith(".jnlp")) {
                CallbackHandler.access$100(this._handler, this._url);
            } else {
                try {
                    HttpRequest httpRequest = JavawsFactory.getHttpRequestImpl();
                    HttpResponse httpResponse = httpRequest.doGetRequest(this._url);
                    inputStream = httpResponse.getInputStream();
                    if (inputStream != null) {
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        ParserDelegator parserDelegator = new ParserDelegator();
                        parserDelegator.parse(inputStreamReader, this._handler, true);
                    }
                }
                catch (IOException iOException) {
                    if (!Globals.TraceHTMLEntryParsing) break block9;
                    Debug.println("IOException parsing html entries " + iOException);
                }
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._handler.notifyWhenFinishedLoadingJNLFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        boolean bl = false;
        if (this._url == null) {
            return;
        }
        HTMLEntryManager hTMLEntryManager = this;
        synchronized (hTMLEntryManager) {
            if (!this._loading) {
                this._loading = true;
                bl = true;
            }
        }
        if (bl) {
            this._entries.clear();
            new Thread(this){
                private final HTMLEntryManager this$0;

                public void run() {
                    HTMLEntryManager.access$000(this.this$0);
                }
                {
                    this.this$0 = hTMLEntryManager;
                }
            }.start();
        }
    }

    void stop() {
        if (this._handler != null) {
            this._handler.stop();
        }
    }

    static void access$000(HTMLEntryManager hTMLEntryManager) {
        hTMLEntryManager.parseURL();
    }

    public JNLEntry get(int n) {
        return (JNLEntry)this._entries.get(n);
    }

    void addEntry(JNLEntry jNLEntry) {
        SwingUtilities.invokeLater(new Runnable(this, jNLEntry){
            private final JNLEntry val$entry;
            private final HTMLEntryManager this$0;

            public void run() {
                if (!HTMLEntryManager.access$200(this.this$0).contains(this.val$entry)) {
                    HTMLEntryManager.access$200(this.this$0).add(this.val$entry);
                    JNLEntry jNLEntry = this.this$0.getSelectedEntry();
                    Collections.sort(HTMLEntryManager.access$200(this.this$0));
                    this.this$0.fireStateChanged();
                    if (jNLEntry != null) {
                        this.this$0.setSelectedIndex(HTMLEntryManager.access$200(this.this$0).indexOf(jNLEntry));
                    } else if (this.this$0.getSelectedIndex() == -1 && this.this$0.size() > 0) {
                        this.this$0.setSelectedIndex(0);
                    }
                }
            }
            {
                this.this$0 = hTMLEntryManager;
                this.val$entry = jNLEntry;
            }
        });
    }

    URL getURL() {
        return this._url;
    }

    public HTMLEntryManager(URL uRL) {
        this();
        this._url = uRL;
    }

    static URL access$500(HTMLEntryManager hTMLEntryManager) {
        return hTMLEntryManager._url;
    }

    static ArrayList access$200(HTMLEntryManager hTMLEntryManager) {
        return hTMLEntryManager._entries;
    }

    private class CallbackHandler
    extends HTMLEditorKit.ParserCallback
    implements Runnable {
        private ArrayList _urls;
        private boolean _bail;
        private int _threadCount;
        private URL _baseURL;
        private final HTMLEntryManager this$0;

        public void flush() throws BadLocationException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyWhenFinishedLoadingJNLFiles() {
            boolean bl;
            CallbackHandler callbackHandler = this;
            synchronized (callbackHandler) {
                bl = this._threadCount == 0;
            }
            if (bl) {
                this.this$0.finishedLoadingJNLFiles();
            } else {
                new Thread(this){
                    private final CallbackHandler this$1;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean bl = false;
                        while (!bl) {
                            CallbackHandler callbackHandler = this.this$1;
                            synchronized (callbackHandler) {
                                boolean bl2 = bl = CallbackHandler.access$300(this.this$1) == 0;
                                if (!bl) {
                                    try {
                                        this.this$1.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        CallbackHandler.access$400(this.this$1).finishedLoadingJNLFiles();
                    }
                    {
                        this.this$1 = callbackHandler;
                    }
                }.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = this._bail;
            while (!bl) {
                URL uRL = null;
                int n = 0;
                CallbackHandler callbackHandler = this;
                synchronized (callbackHandler) {
                    if (this._urls.size() == 0) {
                        bl = true;
                        n = --this._threadCount;
                        this.notifyAll();
                    } else {
                        uRL = (URL)this._urls.remove(0);
                    }
                }
                if (!bl) {
                    this.loadJNLFile(uRL);
                    bl = this._bail;
                    continue;
                }
                if (!Globals.TraceHTMLEntryParsing) continue;
                Debug.println("Thread stopping, remaining threads: " + n);
            }
        }

        public void stop() {
            this._bail = true;
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleText(char[] cArray, int n) {
        }

        public CallbackHandler(HTMLEntryManager hTMLEntryManager) {
            this.this$0 = hTMLEntryManager;
            this._urls = new ArrayList();
        }

        static int access$300(CallbackHandler callbackHandler) {
            return callbackHandler._threadCount;
        }

        public void handleError(String string, int n) {
        }

        private void loadJNLFile(URL uRL) {
            block6: {
                if (Globals.TraceHTMLEntryParsing) {
                    Debug.println("Loading JNL file from: " + uRL);
                }
                try {
                    LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(uRL);
                    if (launchDesc != null && launchDesc.getCanonicalHome() != null && (launchDesc.getLaunchType() == 1 || launchDesc.getLaunchType() == 2)) {
                        InformationDesc informationDesc = launchDesc.getInformation();
                        LocalApplicationProperties localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(launchDesc.getCanonicalHome(), launchDesc);
                        if (informationDesc != null && localApplicationProperties != null) {
                            JNLEntry jNLEntry = new JNLEntry(launchDesc, informationDesc, localApplicationProperties, null, 0L, false, uRL);
                            if (Globals.TraceHTMLEntryParsing) {
                                Debug.println("parsed: " + jNLEntry);
                            }
                            this.this$0.addEntry(jNLEntry);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!Globals.TraceHTMLEntryParsing) break block6;
                    Debug.println("Error loading JNL file from " + uRL + " error " + exception);
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleParsingOfJNLFile(URL uRL) {
            boolean bl = false;
            if (Globals.TraceHTMLEntryParsing) {
                Debug.println("Scheduling URL: " + uRL);
            }
            CallbackHandler callbackHandler = this;
            synchronized (callbackHandler) {
                this._urls.add(uRL);
                boolean bl2 = bl = this._threadCount < 5;
                if (bl) {
                    ++this._threadCount;
                }
            }
            if (bl) {
                new Thread(this).start();
                if (Globals.TraceHTMLEntryParsing) {
                    Debug.println("started thread new thread to parse");
                }
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        static HTMLEntryManager access$400(CallbackHandler callbackHandler) {
            return callbackHandler.this$0;
        }

        static void access$100(CallbackHandler callbackHandler, URL uRL) {
            callbackHandler.scheduleParsingOfJNLFile(uRL);
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            String string;
            if (tag == HTML.Tag.BASE && (string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF)) != null) {
                try {
                    this._baseURL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (tag == HTML.Tag.A && (string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF)) != null && string.endsWith(".jnlp")) {
                URL uRL;
                block9: {
                    uRL = null;
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        URL uRL2;
                        URL uRL3 = uRL2 = this._baseURL != null ? this._baseURL : HTMLEntryManager.access$500(this.this$0);
                        if (uRL2 == null) break block9;
                        try {
                            uRL = new URL(uRL2, string);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            // empty catch block
                        }
                    }
                }
                if (uRL != null) {
                    this.scheduleParsingOfJNLFile(uRL);
                }
            }
        }
    }
}

