/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    private ZipHelper() {
    }

    public static byte[] zip(byte[] anInputByteArray, String entryName) {
        try {
            ZipEntry aZipEntry = new ZipEntry(entryName);
            ByteArrayOutputStream aByteArrayOS = new ByteArrayOutputStream();
            ZipOutputStream aZIPOS = new ZipOutputStream(aByteArrayOS);
            aZIPOS.putNextEntry(aZipEntry);
            aZIPOS.write(anInputByteArray);
            aZIPOS.flush();
            aZIPOS.close();
            aByteArrayOS.flush();
            aByteArrayOS.close();
            return aByteArrayOS.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("zip failed", e);
        }
    }

    public static byte[] unzip(byte[] zipped, String entryName) {
        int BUFFER = 2048;
        try {
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipped));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals(entryName)) {
                    int count;
                    byte[] data = new byte[BUFFER];
                    while ((count = zis.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    return dest.toByteArray();
                }
                entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception e) {
            throw new RuntimeException("unzip failed", e);
        }
        return null;
    }
}

