/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

class Base64URLSafe {
    protected static final char PAD_CHAR = '*';
    protected static final char LETTER_62 = '-';
    protected static final char LETTER_63 = '_';
    protected static final char[] encodeMap;
    protected static byte[] decodeMap;

    Base64URLSafe() {
    }

    public static String encode(byte[] raw) {
        int block;
        int end = raw.length;
        int slop = end % 3;
        char[] buf = new char[slop == 0 ? 4 * (end / 3) : 4 * (end / 3 + 1)];
        int i = 0;
        int j = 0;
        end -= slop;
        while (i < end) {
            block = (raw[i++] & 0xFF) << 16 | (raw[i++] & 0xFF) << 8 | raw[i++] & 0xFF;
            buf[j++] = encodeMap[block >>> 18 & 0x3F];
            buf[j++] = encodeMap[block >>> 12 & 0x3F];
            buf[j++] = encodeMap[block >>> 6 & 0x3F];
            buf[j++] = encodeMap[block & 0x3F];
        }
        if (slop == 2) {
            block = (raw[i++] & 0xFF) << 16 | (raw[i++] & 0xFF) << 8;
            buf[j++] = encodeMap[block >>> 18 & 0x3F];
            buf[j++] = encodeMap[block >>> 12 & 0x3F];
            buf[j++] = encodeMap[block >>> 6 & 0x3F];
            buf[j] = 42;
        } else if (slop == 1) {
            block = (raw[i++] & 0xFF) << 16;
            buf[j++] = encodeMap[block >>> 18 & 0x3F];
            buf[j++] = encodeMap[block >>> 12 & 0x3F];
            buf[j++] = 42;
            buf[j] = 42;
        }
        return new String(buf);
    }

    public static byte[] decode(String base64String) {
        int block;
        char[] base64 = base64String.toCharArray();
        int pad = 0;
        int max = base64.length;
        if (max == 0) {
            return new byte[0];
        }
        int i = max - 1;
        while (base64[i] == '*') {
            ++pad;
            --i;
        }
        byte[] r = new byte[max * 6 / 8 - pad];
        if (pad > 0) {
            max -= 4;
        }
        int ri = 0;
        int i2 = 0;
        while (i2 < max) {
            block = Base64URLSafe.getValue(base64[i2++]) << 18 | Base64URLSafe.getValue(base64[i2++]) << 12 | Base64URLSafe.getValue(base64[i2++]) << 6 | Base64URLSafe.getValue(base64[i2++]);
            r[ri++] = (byte)(block >> 16 & 0xFF);
            r[ri++] = (byte)(block >> 8 & 0xFF);
            r[ri++] = (byte)(block & 0xFF);
        }
        if (pad == 2) {
            block = Base64URLSafe.getValue(base64[i2++]) << 18 | Base64URLSafe.getValue(base64[i2++]) << 12;
            r[ri++] = (byte)(block >> 16 & 0xFF);
        } else if (pad == 1) {
            block = Base64URLSafe.getValue(base64[i2++]) << 18 | Base64URLSafe.getValue(base64[i2++]) << 12 | Base64URLSafe.getValue(base64[i2++]) << 6;
            r[ri++] = (byte)(block >> 16 & 0xFF);
            r[ri++] = (byte)(block >> 8 & 0xFF);
        }
        return r;
    }

    protected static int getValue(char c) {
        byte x = decodeMap[c];
        if (x == -1) {
            throw new RuntimeException("Bad base64 character of value " + c + " found in decode");
        }
        return x;
    }

    static {
        int i;
        encodeMap = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        decodeMap = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64URLSafe.decodeMap[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64URLSafe.decodeMap[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64URLSafe.decodeMap[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64URLSafe.decodeMap[i] = (byte)(52 + i - 48);
        }
        Base64URLSafe.decodeMap[45] = 62;
        Base64URLSafe.decodeMap[95] = 63;
    }
}

