/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrundstueckNummerConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3618977871490462256L;
    private Pattern validatePatternMitPruefziffer = Pattern.compile("([\\d]{4})[-]?([\\d]{2})[-]?([\\d]{6})[-]?([\\d]{3})[-]?([\\d]{3})[-]?([\\d]{1})");
    private Pattern validatePatternOhnePruefziffer = Pattern.compile("([\\d]{4})[-]?([\\d]{2})[-]?([\\d]{6})[-]?([\\d]{3})[-]?([\\d]{3})");
    private Pattern inputPattern = Pattern.compile("([\\d]{0,4})[-]?([\\d]{0,2})[-]?([\\d]{0,6})[-]?([\\d]{0,3})[-]?([\\d]{0,3})[-]?([\\d]{0,1})");

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.validatePatternMitPruefziffer.matcher(s);
        if (!m.matches()) {
            m = this.validatePatternOhnePruefziffer.matcher(s);
            if (!m.matches()) {
                throw new AbstractConverter.ConvertException("error.format.grundstuecknr");
            }
            return m.group(1) + "-" + m.group(2) + "-" + m.group(3) + "-" + m.group(4) + "-" + m.group(5);
        }
        return m.group(1) + "-" + m.group(2) + "-" + m.group(3) + "-" + m.group(4) + "-" + m.group(5) + "-" + m.group(6);
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.validatePatternMitPruefziffer.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "-" + m.group(2) + "-" + m.group(3) + "-" + m.group(4) + "-" + m.group(5) + "-" + m.group(6);
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return this.inputPattern.pattern();
    }
}

