/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import java.text.DecimalFormat;

public abstract class FloatConverter
extends NumberConverter {
    private static final long serialVersionUID = 1L;
    protected int numDec;
    private DecimalFormat format;
    private boolean dynamicFP;

    protected FloatConverter(int maxLength, int numDec, DecimalFormat format, boolean dynamicFP) {
        super(maxLength);
        this.numDec = numDec;
        this.format = format;
        this.dynamicFP = dynamicFP;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        try {
            s = s.replaceAll("'", "");
            this.checkFloatingPointNumberLength(s, this.maxLength, this.numDec);
            return Double.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            throw new AbstractConverter.ConvertException("error.format.float-" + this.numDec, this.maxLength - this.numDec + 1);
        }
    }

    protected void checkFloatingPointNumberLength(String value, int totalLength, int lengthAfterPoint) throws NumberFormatException {
        int pos = value.indexOf(".");
        if (pos < 0 && value.length() + 1 > totalLength - lengthAfterPoint) {
            throw new NumberFormatException("max length exceeded");
        }
        if (pos >= 0 && pos + 1 > totalLength - lengthAfterPoint) {
            throw new NumberFormatException("max length exceeded");
        }
        if (pos >= 0 && value.length() - pos > lengthAfterPoint + 1) {
            throw new NumberFormatException("max length exceeded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (o instanceof Number) {
            double value = ((Number)o).doubleValue();
            if (value == 0.0 && readonly) {
                return "";
            }
            DecimalFormat decimalFormat = this.format;
            synchronized (decimalFormat) {
                return this.format.format(value);
            }
        }
        return o.toString();
    }

    public int getNumDec() {
        return this.numDec;
    }

    public boolean isDynamicFP() {
        return this.dynamicFP;
    }

    public int getMaxLength() {
        return this.maxLength + 1;
    }
}

