/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.FormatHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DayMonthConverter
extends AbstractConverter {
    private Long steuerjahr;
    private static final long serialVersionUID = 3257844376993477682L;
    private static final SimpleDateFormat sdf_render = new SimpleDateFormat("dd.MM");

    public DayMonthConverter(Long steuerjahr) {
        this.steuerjahr = steuerjahr;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        try {
            return this.parse(s);
        }
        catch (Exception e) {
            throw new AbstractConverter.ConvertException("error.format.daymonth", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            SimpleDateFormat simpleDateFormat = sdf_render;
            synchronized (simpleDateFormat) {
                return sdf_render.format((Date)o);
            }
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "([0-9]{1,2})(\\.?)([0-9]{0,2})";
    }

    private Date parse(String input) throws Exception {
        StringBuffer sb = new StringBuffer(input);
        if (!input.endsWith(".")) {
            sb.append(".");
        }
        sb.append(this.steuerjahr.toString());
        String date = sb.toString();
        Calendar aCalendar = FormatHelper.getCalendar(date);
        if (aCalendar == null) {
            date = date.replaceAll("\\.", "");
            aCalendar = FormatHelper.getCalendar(date);
        }
        if (aCalendar == null && (aCalendar = FormatHelper.getCalendar(input)) != null) {
            aCalendar.set(1, this.steuerjahr.intValue());
        }
        return aCalendar.getTime();
    }

    public int getMaxLength() {
        return 7;
    }
}

