/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.FormatHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3258417239630688823L;
    private SimpleDateFormat sdf_render;
    private int MIN_YEAR = 1800;

    public DateConverter() {
        this("dd.MM.yyyy");
    }

    public DateConverter(String renderFormat) {
        this.sdf_render = new SimpleDateFormat(renderFormat);
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Calendar cal = null;
        try {
            cal = FormatHelper.getCalendar(s);
        }
        catch (Exception e) {
            throw new AbstractConverter.ConvertException("error.format.date", e);
        }
        if (cal == null) {
            throw new AbstractConverter.ConvertException("error.format.date");
        }
        if (cal.get(1) < this.MIN_YEAR) {
            throw new AbstractConverter.ConvertException("error.date.min");
        }
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            SimpleDateFormat simpleDateFormat = this.sdf_render;
            synchronized (simpleDateFormat) {
                return this.sdf_render.format((Date)o);
            }
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "([0-9]{1,2})(\\.?)([0-9]{0,2})(\\.?)([0-9]{0,4})";
    }

    public int getMaxLength() {
        return 10;
    }
}

