/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;

public class BooleanConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3690473610909268018L;
    private boolean printLabel;

    public BooleanConverter() {
        this(false);
    }

    public BooleanConverter(boolean printLabel) {
        this.printLabel = printLabel;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        Boolean result = Boolean.FALSE;
        if ("true".equalsIgnoreCase(s)) {
            result = Boolean.TRUE;
        }
        return result;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        return this.renderLabel(o, locHelper, "label.ja", "label.nein");
    }

    private String renderLabel(Object o, LocalizationHelper locHelper, String trueKey, String falseKey) {
        if (o == null) {
            return "";
        }
        try {
            if (o instanceof Boolean) {
                if (((Boolean)o).booleanValue()) {
                    return locHelper.translate(trueKey, null);
                }
                return locHelper.translate(falseKey, null);
            }
            return o.toString();
        }
        catch (Exception e) {
            return o.toString();
        }
    }

    public String getRenderedValueToPrint(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (this.printLabel) {
            return this.renderLabel(o, locHelper, "label.print.ja", "label.print.nein");
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return "X";
            }
            return " ";
        }
        return " ";
    }
}

