/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AhvConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3618977871490462256L;
    private Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d)(\\.?)(\\d\\d\\d)");
    private Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d)(\\d\\d\\d)");

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "." + m.group(4);
        }
        return o.toString();
    }

    public int getMaxLength() {
        return 14;
    }
}

