/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class WizardDisplayInfoDTO
implements Serializable {
    private static final long serialVersionUID = 3763094171963307828L;
    private FormItemDTO formItemDTO;
    private NavigationDTO navigationDTO;
    private Collection deleteWarnings;
    private boolean released;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_RADIO = 1;
    public static final int TYPE_COMBO = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_HIDDEN = 100;

    public WizardDisplayInfoDTO(FormItemDTO formItemDTO, NavigationDTO navigationDTO, boolean released) {
        this.formItemDTO = formItemDTO;
        this.navigationDTO = navigationDTO;
        this.released = released;
    }

    public FormItemDTO getFormItemDTO() {
        return this.formItemDTO;
    }

    public List getNavigationsItemDTO() {
        return this.getNavigationDTO().getNavigationsItems();
    }

    public NavigationDTO getNavigationDTO() {
        return this.navigationDTO;
    }

    public String getThisKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getThisKey();
        }
        return null;
    }

    public String getNextKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getNextKey();
        }
        return null;
    }

    public String getPrevKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getPrevKey();
        }
        return null;
    }

    public String getBackKey() {
        if (this.getNavigationDTO() != null) {
            return this.getNavigationDTO().getBackKey();
        }
        return null;
    }

    public void setDeleteWarnings(Collection deleteWarnings) {
        this.deleteWarnings = deleteWarnings;
    }

    public Collection getDeleteWarnings() {
        return this.deleteWarnings;
    }

    public boolean isReleased() {
        return this.released;
    }

    public static void collectMessagesOnWizardDisplayForm(FormItemDTO formDTO) {
        WizardDisplayInfoDTO.collectMessagesOnWizardDisplayForm(formDTO, Collections.EMPTY_SET);
    }

    public static void collectMessagesOnWizardDisplayForm(FormItemDTO formDTO, Set dmksToIgnore) {
        if (formDTO != null && formDTO.getChildren() != null) {
            Iterator i = formDTO.getChildren().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof SectionItemDTO)) continue;
                SectionItemDTO siDTO = (SectionItemDTO)o;
                ArrayList messages = new ArrayList();
                WizardDisplayInfoDTO.collectItemMessages(siDTO, messages, dmksToIgnore);
                Iterator j = messages.iterator();
                while (j.hasNext()) {
                    MessageItemDTO miDTO = (MessageItemDTO)j.next();
                    if (!"".equals(miDTO.getKey())) continue;
                    j.remove();
                }
                siDTO.setMessages(messages);
            }
        }
    }

    public static void collectItemMessages(Object o, List messages) {
        WizardDisplayInfoDTO.collectItemMessages(o, messages, Collections.EMPTY_SET);
    }

    public static void collectItemMessages(Object o, List messages, Set dmksToIgnore) {
        if (o instanceof AbstractItemDTO && !((AbstractItemDTO)o).hasStateForVisibleMessages()) {
            return;
        }
        if (o instanceof SectionItemDTO && ((SectionItemDTO)o).getRows() != null) {
            Iterator i = ((SectionItemDTO)o).getRows().iterator();
            while (i.hasNext()) {
                WizardDisplayInfoDTO.collectItemMessages(i.next(), messages);
            }
        } else if (o instanceof TableItemDTO && ((TableItemDTO)o).getRows() != null) {
            Iterator i = ((TableItemDTO)o).getRows().iterator();
            while (i.hasNext()) {
                WizardDisplayInfoDTO.collectItemMessages(i.next(), messages);
            }
        } else if (o instanceof RowItemDTO && ((RowItemDTO)o).getCols() != null) {
            Iterator i = ((RowItemDTO)o).getCols().iterator();
            while (i.hasNext()) {
                WizardDisplayInfoDTO.collectItemMessages(i.next(), messages);
            }
        } else if (o instanceof ItemItemDTO && ((ItemItemDTO)o).getMessages() != null && !dmksToIgnore.contains(((ItemItemDTO)o).getDataModelKey())) {
            messages.addAll(((ItemItemDTO)o).getMessages());
        }
    }

    public static class NavigationsItemDTO
    implements Serializable {
        private static final long serialVersionUID = 3256442495255982129L;
        private String key;
        private String title;
        private int state;
        private boolean selected;
        private List children;
        private NavigationsItemDTO parent;

        public boolean equals(Object object) {
            if (!(object instanceof NavigationsItemDTO)) {
                return false;
            }
            NavigationsItemDTO navigationsItemDTO = (NavigationsItemDTO)object;
            if (!this.key.equals(navigationsItemDTO.getKey())) {
                return false;
            }
            if (!this.title.equals(navigationsItemDTO.getTitle())) {
                return false;
            }
            if (this.state != navigationsItemDTO.getState()) {
                return false;
            }
            if (this.selected != navigationsItemDTO.isSelected()) {
                return false;
            }
            if (this.children != null && navigationsItemDTO.getChildren() != null) {
                if (this.children.size() != navigationsItemDTO.getChildren().size()) {
                    return false;
                }
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    if (this.getChildren().get(i).equals(navigationsItemDTO.getChildren().get(i))) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return this.key;
        }

        public NavigationsItemDTO(String key, String title, int state, boolean selected, List children) {
            this.key = key;
            this.title = title;
            this.state = state;
            this.selected = selected;
            this.children = children;
            this.parent = null;
            if (children != null) {
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    NavigationsItemDTO element = (NavigationsItemDTO)iter.next();
                    element.setParent(this);
                }
            }
        }

        public List getChildren() {
            return this.children;
        }

        public NavigationsItemDTO getParent() {
            return this.parent;
        }

        public void setParent(NavigationsItemDTO parent) {
            this.parent = parent;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getState() {
            return this.state;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void printNavigation(String indent) {
            System.out.println(indent + this.key + " " + this.state + " " + this.selected);
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                NavigationsItemDTO element = (NavigationsItemDTO)this.children.get(i);
                element.printNavigation(indent + "  ");
            }
        }
    }

    public static class ButtonDTO
    extends AbstractItemDTO
    implements RowContent,
    ReRenderer {
        private static final long serialVersionUID = 3257569494791434296L;
        private int colspan;
        private String uri;
        private String name;
        private String dmk;
        private String target;
        private String dmkValue;
        private Integer width;
        private Integer height;
        private boolean transparentIfView;
        private String reRender;

        public ButtonDTO(long uniqueItemIdentifier, String uri, String name, String dmk, String dmkValue, String target, int colspan, boolean transparentIfView, Integer width, Integer height, String reRender) {
            super(uniqueItemIdentifier, 1);
            this.uri = uri;
            this.name = name;
            this.dmk = dmk;
            this.dmkValue = dmkValue;
            this.target = target;
            this.colspan = colspan;
            this.transparentIfView = transparentIfView;
            this.width = width;
            this.height = height;
            this.reRender = reRender;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }

        public String getDmk() {
            return this.dmk;
        }

        public String getTarget() {
            return this.target;
        }

        public int getColspan() {
            return this.colspan;
        }

        public String getStyle() {
            return "";
        }

        public boolean isTransparentIfView() {
            return this.transparentIfView;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public String getDmkValue() {
            return this.dmkValue;
        }

        public int getRowspan() {
            return 1;
        }

        public String getReRender() {
            return this.reRender;
        }

        public void setReRender(String reRender) {
            this.reRender = reRender;
        }
    }

    public static class BRItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3256442516780692274L;

        public BRItemDTO(long uniqueItemIdentifier) {
            super(uniqueItemIdentifier, 1);
        }
    }

    public static class StateItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 4121699876493865012L;

        public StateItemDTO(Object uniqueItemIdentifier, int state) {
            super(uniqueItemIdentifier, state);
        }
    }

    public static class ColItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3616447899530310195L;
        private List itemDTOs;

        public ColItemDTO(long uniqueItemIdentifier, int state, List itemDTOs) {
            super(uniqueItemIdentifier, state);
            this.itemDTOs = itemDTOs;
        }

        public List getItems() {
            return this.itemDTOs;
        }
    }

    public static class TableItemDTO
    extends AbstractItemDTO
    implements RowContent {
        private static final long serialVersionUID = 3256721796996019254L;
        private List coldefs;
        private List rows;
        private HelpItemDTO help;
        private String dataModelKey;
        private String header;
        private List labelAddOns;
        private boolean isSubnavigation;
        private boolean editable;
        private RowItemDTO emptyRow;
        private String align;
        private int colspan;
        private int rowspan;
        private String logicModelKey;
        private boolean readOnly;
        private String viewId;
        private int rowsPerPage;
        private boolean filter;

        public TableItemDTO(long uniqueItemIdentifier, int state, String dataModelKey, String header, List labelAddOns, List coldefs, List rows, HelpItemDTO help, boolean isSubnavigation, boolean editable, RowItemDTO emptyRow, String align, int colspan, int rowspan, boolean readOnly, String viewId, int rowsPerPage, boolean filter) {
            super(uniqueItemIdentifier, state);
            this.coldefs = coldefs;
            this.rows = rows;
            this.dataModelKey = dataModelKey;
            this.header = header;
            this.labelAddOns = labelAddOns;
            this.help = help;
            this.isSubnavigation = isSubnavigation;
            this.editable = editable;
            this.emptyRow = emptyRow;
            this.align = align;
            this.rowspan = rowspan;
            this.colspan = colspan;
            this.logicModelKey = EngineUtil.removeTableIndices(dataModelKey);
            this.readOnly = readOnly;
            this.viewId = viewId;
            this.rowsPerPage = rowsPerPage;
            this.filter = filter;
        }

        public List getColdefs() {
            return this.coldefs;
        }

        public void setColdefs(List coldefs) {
            this.coldefs = coldefs;
        }

        public List getRows() {
            return this.rows;
        }

        public String getHeader() {
            return this.header;
        }

        public String getDataModelKey() {
            return this.dataModelKey;
        }

        public String getLogicModelKey() {
            return this.logicModelKey;
        }

        public HelpItemDTO getHelp() {
            return this.help;
        }

        public int getCntCols() {
            return this.getColdefs().size() + 2;
        }

        public boolean getIsSubnavigation() {
            return this.isSubnavigation;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public RowItemDTO getEmptyRow() {
            return this.emptyRow;
        }

        public String getAlign() {
            return this.align;
        }

        public int getColspan() {
            return this.colspan;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public String getViewId() {
            return this.viewId;
        }

        public void setViewId(String viewId) {
            this.viewId = viewId;
        }

        public List getLabelAddOns() {
            return this.labelAddOns;
        }

        public int getRowsPerPage() {
            return this.rowsPerPage;
        }

        public boolean removeRow(RowItemDTO rowItemDTO) {
            return this.rows.remove(rowItemDTO);
        }

        public boolean isFilter() {
            return this.filter;
        }
    }

    public static class HelpItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3906087858295879222L;
        private String id;

        public HelpItemDTO(long uniqueItemIdentifier, int state, String id) {
            super(uniqueItemIdentifier, state);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            return ((HelpItemDTO)other).id.equals(this.id);
        }
    }

    public static class ItemItemDTO
    extends AbstractItemDTO
    implements RowContent,
    ReRenderer {
        private static final long serialVersionUID = 3906934486578312753L;
        private int type;
        private String dataModelKey;
        private Object value;
        private int colspan;
        private OptionItemsDTO optionItems;
        private Collection messages;
        private boolean readonly;
        private String align;
        private String style;
        private String id;
        private boolean negative;
        private AbstractConverter rendererAndInputValidator;
        private boolean validateIfEmpty;
        private String shortHelpKey;
        private String fgColor;
        private String reRender;

        public ItemItemDTO(Object uniqueItemIdentifier, int state, int type, String dataModelKey, Object value, int colspan, OptionItemsDTO optionItems, Collection messages, boolean readonly, String align, String style, String id, boolean negative, AbstractConverter rendererAndInputValidator, boolean validateIfLeftEmpty, String shortHelpKey, String fgColor, String reRender) {
            super(uniqueItemIdentifier, state);
            this.type = type;
            this.dataModelKey = dataModelKey;
            this.value = value;
            this.colspan = colspan;
            this.optionItems = optionItems;
            this.messages = messages;
            this.readonly = readonly;
            this.align = align;
            this.style = style;
            this.id = id;
            this.negative = negative;
            this.rendererAndInputValidator = rendererAndInputValidator;
            this.validateIfEmpty = validateIfLeftEmpty;
            this.shortHelpKey = shortHelpKey;
            this.fgColor = fgColor;
            this.reRender = reRender;
        }

        public String getForegroundColor() {
            return this.fgColor;
        }

        public void setState(int state) {
            ((AbstractItemDTO)this).state = state;
        }

        public int getType() {
            return this.type;
        }

        public String getDataModelKey() {
            return this.dataModelKey;
        }

        public Object getValue() {
            if (this.negative && this.value instanceof Double) {
                return new Double(0.0 - ((Number)this.value).doubleValue());
            }
            if (this.negative && this.value instanceof Long) {
                return new Long(0L - ((Number)this.value).longValue());
            }
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public int getColspan() {
            return this.colspan;
        }

        public int getMaxlength() {
            if (this.rendererAndInputValidator != null) {
                return this.rendererAndInputValidator.getMaxLength();
            }
            return 100;
        }

        public OptionItemsDTO getOptionItems() {
            return this.optionItems;
        }

        public Collection getMessages() {
            return this.messages;
        }

        public boolean getReadonly() {
            return this.readonly;
        }

        public String getAlign() {
            return this.align;
        }

        public String getStyle() {
            return this.style;
        }

        public String getId() {
            return this.id != null ? "\"" + this.id + "\"" : null;
        }

        public void addMessage(MessageItemDTO message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
        }

        public void removeMessage(MessageItemDTO message) {
            if (this.messages != null) {
                this.messages.remove(message);
                if (this.messages.size() == 0) {
                    this.messages = null;
                }
            }
        }

        public AbstractConverter getRendererAndInputValidator() {
            return this.rendererAndInputValidator;
        }

        public boolean isValidateIfLeftEmpty() {
            return this.validateIfEmpty;
        }

        public int getRowspan() {
            return 1;
        }

        public String getShortHelpKey() {
            return this.shortHelpKey;
        }

        public String getReRender() {
            return this.reRender;
        }
    }

    public static class LabelAddOnDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Object value;
        private AbstractConverter rendererAndInputValidator;
        private OptionItemsDTO optionItems;
        private Integer length;
        private String fillpattern;

        public LabelAddOnDTO(Object value, AbstractConverter rendererAndInputValidator, OptionItemsDTO optionItems, Integer length, String fillpattern) {
            this.value = value;
            this.rendererAndInputValidator = rendererAndInputValidator;
            this.optionItems = optionItems;
            this.length = length;
            this.fillpattern = fillpattern;
        }

        public Object getValue() {
            return this.value;
        }

        public AbstractConverter getRendererAndInputValidator() {
            return this.rendererAndInputValidator;
        }

        public OptionItemsDTO getOptionItems() {
            return this.optionItems;
        }

        public Integer getLength() {
            return this.length;
        }

        public String getFillpattern() {
            return this.fillpattern;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class LabelItemDTO
    extends AbstractItemDTO
    implements RowContent {
        private static final long serialVersionUID = 3977012938160747316L;
        private Object name;
        private int colspan;
        private String align;
        private String style;
        private List labelAddOns;
        private String toString;
        private String fgColor;

        public LabelItemDTO(long uniqueItemIdentifier, int state, String name, int colspan, String align, String style, List labelAddOns, String fgColor) {
            super(uniqueItemIdentifier, state);
            this.name = name;
            this.colspan = colspan;
            this.align = align;
            this.style = style;
            this.labelAddOns = labelAddOns;
            this.fgColor = fgColor;
        }

        public String getForegroundColor() {
            return this.fgColor;
        }

        public Object getName() {
            return this.name;
        }

        public int getColspan() {
            return this.colspan;
        }

        public String getAlign() {
            return this.align;
        }

        public String getStyle() {
            return this.style;
        }

        public List getLabelAddOns() {
            return this.labelAddOns;
        }

        public int getRowspan() {
            return 1;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuffer sb = new StringBuffer();
                if (this.name != null) {
                    sb.append(this.name.toString());
                }
                if (this.labelAddOns != null && this.labelAddOns.size() > 0) {
                    sb.append(" {");
                    Iterator it = this.labelAddOns.iterator();
                    while (it.hasNext()) {
                        LabelAddOnDTO element = (LabelAddOnDTO)it.next();
                        sb.append(element.toString());
                        sb.append(",");
                    }
                    sb.append("}");
                }
                this.toString = sb.toString();
            }
            return this.toString;
        }
    }

    public static class RowItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3256721779782202676L;
        private HelpItemDTO help;
        private List cols;
        private String dmkTableEntry;
        private boolean deletable;
        private String viewId;

        public RowItemDTO(Object uniqueItemIdentifier, int state, String dmkTableEntry, List cols, HelpItemDTO help, boolean deletable, String viewId) {
            super(uniqueItemIdentifier, state);
            this.dmkTableEntry = dmkTableEntry;
            this.cols = cols;
            this.help = help;
            this.deletable = deletable;
            this.viewId = viewId;
        }

        public String getDmkTableEntry() {
            return this.dmkTableEntry;
        }

        public List getCols() {
            return this.cols;
        }

        public void addChild(AbstractItemDTO child) {
            if (this.cols == null) {
                this.cols = new ArrayList();
            }
            this.cols.add(child);
        }

        public HelpItemDTO getHelp() {
            return this.help;
        }

        public boolean isDeletable() {
            return this.deletable;
        }

        public String getViewId() {
            return this.viewId;
        }
    }

    public static class HeaderItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3834589889839575605L;
        private String name;
        private int colspan;
        private List headerAddOns;

        public HeaderItemDTO(long uniqueItemIdentifier, int state, String name, int colspan, List headerAddOns) {
            super(uniqueItemIdentifier, state);
            this.name = name;
            this.colspan = colspan;
            this.headerAddOns = headerAddOns;
        }

        public String getName() {
            return this.name;
        }

        public int getColspan() {
            return this.colspan;
        }

        public List getHeaderAddOns() {
            return this.headerAddOns;
        }

        public String getText(LocalizationHelper localisationHelper) throws FormRendererException {
            try {
                List addons = this.getHeaderAddOns();
                Object[] args = null;
                if (addons != null && addons.size() > 0) {
                    args = new Object[addons.size()];
                    for (int i = 0; i < args.length; ++i) {
                        LabelAddOnDTO element = (LabelAddOnDTO)addons.get(i);
                        AbstractConverter conv = element.getRendererAndInputValidator();
                        StringBuffer s = new StringBuffer(conv.getRenderedValue(element.getValue(), false, element.getOptionItems(), localisationHelper));
                        if (element.getLength() != null) {
                            if (s.length() > element.getLength()) {
                                s.setLength(element.getLength());
                            }
                            while (s.length() < element.getLength() && element.getFillpattern() != null) {
                                s.insert(0, element.getFillpattern());
                            }
                        }
                        args[i] = s.toString();
                    }
                }
                return localisationHelper.translate(this.getName().toString(), args);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                throw new FormRendererException("translation failed", e);
            }
        }
    }

    public static class ColDefItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3257286941727994681L;
        private String width;
        private String header;
        private List headerAddOns;
        private String align;
        private boolean filter;

        public ColDefItemDTO(long uniqueItemIdentifier, int state, String width, String header, List headerAddOns, String align, boolean filter) {
            super(uniqueItemIdentifier, state);
            this.width = width;
            this.header = header;
            this.headerAddOns = headerAddOns;
            this.align = align;
            this.filter = filter;
        }

        public String getWidth() {
            return this.width;
        }

        public String getHeader() {
            return this.header;
        }

        public String getAlign() {
            return this.align;
        }

        public List getHeaderAddOns() {
            return this.headerAddOns;
        }

        public boolean isFilter() {
            return this.filter;
        }
    }

    public static class SectionItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3257568390867401017L;
        private List coldefs;
        private List headers;
        private HelpItemDTO help;
        private List rows;
        private boolean readonly;
        private List messages;
        private String viewId;

        public SectionItemDTO(long uniqueItemIdentifier, int state, List coldefs, List headers, HelpItemDTO help, List rows, boolean readonly, String viewId) {
            super(uniqueItemIdentifier, state);
            this.coldefs = coldefs;
            this.headers = headers;
            this.help = help;
            this.rows = rows;
            this.readonly = readonly;
            this.viewId = viewId;
        }

        public List getColdefs() {
            return this.coldefs;
        }

        public List getHeaders() {
            return this.headers;
        }

        public List getRows() {
            return this.rows;
        }

        public HelpItemDTO getHelp() {
            return this.help;
        }

        public List getMessages() {
            return this.messages;
        }

        public void setMessages(List messages) {
            this.messages = messages;
        }

        public void setRows(List rows) {
            this.rows = rows;
        }

        public void setColdefs(List coldefs) {
            this.coldefs = coldefs;
        }

        public int getCntCols() {
            return this.coldefs.size() + 1;
        }

        public boolean getReadonly() {
            return this.readonly;
        }

        public void addMessage(MessageItemDTO message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
        }

        public void addMessages(Collection msgs) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(msgs);
        }

        public void removeMessage(MessageItemDTO message) {
            if (this.messages != null) {
                this.messages.remove(message);
                if (this.messages.size() == 0) {
                    this.messages = null;
                }
            }
        }

        public boolean hasErrors() {
            if (this.getMessages() == null) {
                return false;
            }
            Iterator i = this.getMessages().iterator();
            while (i.hasNext()) {
                MessageItemDTO miDTO = (MessageItemDTO)i.next();
                if (miDTO.getType() != 4) continue;
                return true;
            }
            return false;
        }

        public boolean hasWarnings() {
            if (this.getMessages() == null) {
                return false;
            }
            Iterator i = this.getMessages().iterator();
            while (i.hasNext()) {
                MessageItemDTO miDTO = (MessageItemDTO)i.next();
                if (miDTO.getType() != 2) continue;
                return true;
            }
            return false;
        }

        public String getViewId() {
            return this.viewId;
        }

        public void setViewId(String viewId) {
            this.viewId = viewId;
        }
    }

    public static class FormItemDTO
    extends AbstractItemDTO {
        private static final long serialVersionUID = 3257854259579203889L;
        private String name;
        private String header;
        private List labelAddOns;
        private List children;
        private boolean isTableEntry;
        private String editOut;
        private boolean allNavigationItemsTouched;

        public FormItemDTO(long uniqueItemIdentifier, int state, String name, String header, List labelAddOns, List children, String editOut) {
            super(uniqueItemIdentifier, state);
            this.children = children;
            this.name = name;
            this.header = header;
            this.isTableEntry = false;
            this.editOut = editOut;
            this.labelAddOns = labelAddOns;
        }

        public List getChildren() {
            return this.children;
        }

        public Collection getMessages() {
            LinkedHashSet messages = new LinkedHashSet();
            if (this.getChildren() != null) {
                Iterator iter = this.getChildren().iterator();
                while (iter.hasNext()) {
                    TableItemDTO tableItemDTO;
                    AbstractItemDTO formChild = (AbstractItemDTO)iter.next();
                    if (formChild instanceof SectionItemDTO) {
                        if (((SectionItemDTO)formChild).getMessages() == null) continue;
                        messages.addAll(((SectionItemDTO)formChild).getMessages());
                        continue;
                    }
                    if (!(formChild instanceof TableItemDTO) || !((TableItemDTO)formChild).isEditable() || (tableItemDTO = (TableItemDTO)formChild).getRows() == null) continue;
                    Iterator iteratorRows = tableItemDTO.getRows().iterator();
                    while (iteratorRows.hasNext()) {
                        RowItemDTO rowItemDTO = (RowItemDTO)iteratorRows.next();
                        Iterator iteratorCols = rowItemDTO.getCols().iterator();
                        while (iteratorCols.hasNext()) {
                            ItemItemDTO itemItemDTO;
                            Object element = iteratorCols.next();
                            if (!(element instanceof ItemItemDTO) || (itemItemDTO = (ItemItemDTO)element).getMessages() == null) continue;
                            messages.addAll(itemItemDTO.getMessages());
                        }
                    }
                }
            }
            return messages;
        }

        public String getName() {
            return this.name;
        }

        public String getHeader() {
            return this.header;
        }

        public String getEditOut() {
            return this.editOut;
        }

        public void setEditOut(String editOut) {
            this.editOut = editOut;
        }

        public boolean getIsTableEntry() {
            return this.isTableEntry;
        }

        public void setIsTableEntry(boolean isTableEntry) {
            this.isTableEntry = isTableEntry;
        }

        public boolean getAllNavigationItemsTouched() {
            return this.allNavigationItemsTouched;
        }

        public void setAllNavigationItemsTouched(boolean allNavigationItemsTouched) {
            this.allNavigationItemsTouched = allNavigationItemsTouched;
        }

        public List getLabelAddOns() {
            return this.labelAddOns;
        }
    }

    public static interface ReRenderer {
        public String getReRender();
    }

    public static interface RowContent {
        public int getColspan();

        public int getRowspan();
    }

    public static class AbstractItemDTO
    implements Serializable {
        private static final long serialVersionUID = 3688503290383970865L;
        private int state;
        private Object uniqueItemIdentifier;

        public AbstractItemDTO(long uniqueItemIdentifier, int state) {
            this(new Long(uniqueItemIdentifier), state);
        }

        public AbstractItemDTO(Object uniqueItemIdentifier, int state) {
            this.state = state;
            this.uniqueItemIdentifier = uniqueItemIdentifier;
        }

        public int getState() {
            return this.state;
        }

        public Object getUniqueItemIdentifier() {
            return this.uniqueItemIdentifier;
        }

        public boolean hasStateForVisibleMessages() {
            return this.state != 11 && this.state != 12;
        }
    }

    public static class NavigationDTO
    implements Serializable {
        private static final long serialVersionUID = 3258131340921747507L;
        private List navigationsItems;
        private String nextKey;
        private String prevKey;
        private String backKey;
        private String thisKey;
        private int state;

        public NavigationDTO(List navigationsItems, String nextKey, String prevKey, String backKey, String thisKey, int state) {
            this.navigationsItems = navigationsItems;
            this.nextKey = nextKey;
            this.prevKey = prevKey;
            this.backKey = backKey;
            this.thisKey = thisKey;
            this.state = state;
        }

        public List getNavigationsItems() {
            return this.navigationsItems;
        }

        public String getNextKey() {
            return this.nextKey;
        }

        public String getPrevKey() {
            return this.prevKey;
        }

        public String getBackKey() {
            return this.backKey;
        }

        public String getThisKey() {
            return this.thisKey;
        }

        public int getState() {
            return this.state;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            NavigationDTO other = (NavigationDTO)obj;
            return NavigationDTO.equals(this.nextKey, other.nextKey) && NavigationDTO.equals(this.prevKey, other.prevKey) && NavigationDTO.equals(this.backKey, other.backKey) && NavigationDTO.equals(this.thisKey, other.thisKey) && this.state == other.state && NavigationDTO.equals(this.navigationsItems, other.navigationsItems);
        }

        private static boolean equals(Object obj1, Object obj2) {
            if (obj1 != null) {
                return obj1.equals(obj2);
            }
            if (obj2 != null) {
                return obj2.equals(obj1);
            }
            return true;
        }
    }
}

