/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OptionItemsDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean localized;
    private Map optionItems;

    public OptionItemsDTO(boolean localized, Map optionItems) {
        this.localized = localized;
        this.optionItems = optionItems;
        if (optionItems == null) {
            throw new RuntimeException("optionItems argument in " + this.getClass().getName() + " must not be null");
        }
        if (localized) {
            Iterator i = optionItems.values().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof Map) continue;
                throw new RuntimeException("localized optionItems must contain values instanceof Map");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set getOptionKeys() {
        if (this.localized) {
            if (this.optionItems == null) return null;
            if (this.optionItems.size() <= 0) return Collections.EMPTY_SET;
            Object o = this.optionItems.values().iterator().next();
            if (!(o instanceof Map)) return null;
            return ((Map)o).keySet();
        }
        if (this.optionItems == null) return null;
        return this.optionItems.keySet();
    }

    public OptionItemDTO get(Object key) {
        if (this.isLocalized()) {
            if (this.optionItems.size() > 0) {
                return (OptionItemDTO)((Map)this.optionItems.values().iterator().next()).get(key);
            }
        } else {
            return (OptionItemDTO)this.optionItems.get(key);
        }
        return null;
    }

    public OptionItemDTO get(Object key, Locale locale) {
        if (this.isLocalized()) {
            Map m = (Map)this.optionItems.get(locale.getLanguage());
            if (m != null) {
                return (OptionItemDTO)m.get(key);
            }
        } else {
            return (OptionItemDTO)this.optionItems.get(key);
        }
        return null;
    }

    public Map getOptionItems() {
        return this.optionItems;
    }

    public Map getOptionItems(Locale locale) {
        if (this.isLocalized() && this.optionItems != null) {
            Map result = (Map)this.optionItems.get(locale.getLanguage());
            if (result == null && this.optionItems.size() > 0) {
                result = (Map)this.optionItems.values().iterator().next();
            }
            return result;
        }
        return this.optionItems;
    }

    public boolean isLocalized() {
        return this.localized;
    }
}

