/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.tools;

import ch.dvbern.tax.common.transfer.ejb.TmoAdminFacadeHome;
import ch.dvbern.tax.common.transfer.ejb.TmoAdminFacadeRemote;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class ModelDeployer {
    private static final String EJB_TMO_ADMIN_FACADE = "/ejb/TmoAdminFacade";
    private String adminFacadejndiName;
    private String modelPath = "target/model/model.xml";
    private String resourcesPath = "config/common/resources/tmo_resources_";

    public void deployModel() throws Exception {
        this.getAdminFacade().uploadTmoModel(this.getTmoModel(), "model.xml");
    }

    public void deployResources(Locale locale) throws Exception {
        String filenameWithPath = this.resourcesPath + locale.getLanguage() + ".properties";
        String filename = new File(filenameWithPath).getName();
        this.getAdminFacade().setResources(this.getResources(filenameWithPath), filename);
    }

    public void deployResources(Locale locale, String variant) throws Exception {
        String filenameWithPath = this.resourcesPath + variant + "_" + locale.getLanguage() + ".properties";
        String filename = new File(filenameWithPath).getName();
        this.getAdminFacade().setResources(this.getResources(filenameWithPath), filename);
    }

    protected TmoAdminFacadeRemote getAdminFacade() throws Exception {
        InitialContext initialContext = new InitialContext(this.getEnv());
        Object objRef = initialContext.lookup(this.getAdminFacadeJndiName());
        TmoAdminFacadeHome home = (TmoAdminFacadeHome)PortableRemoteObject.narrow((Object)objRef, (Class)TmoAdminFacadeHome.class);
        return home.create();
    }

    protected Hashtable getEnv() {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", "org.jboss.security.jndi.JndiLoginInitialContextFactory");
        properties.setProperty("java.naming.provider.url", "jnp://localhost:1099");
        properties.setProperty("java.naming.factory.url.pkgs", "org.jnp.interfaces.NamingContextFactory");
        properties.setProperty("java.naming.security.principal", "admin");
        properties.setProperty("java.naming.security.credentials", "admin");
        return properties;
    }

    protected String getTmoModel() throws IOException {
        return this.getContent(this.modelPath);
    }

    public String getAdminFacadeJndiName() {
        if (this.adminFacadejndiName == null) {
            String prefix = System.getProperty("ejb.jndi.prefix");
            if (prefix == null) {
                throw new RuntimeException("'ejb.jndi.prefix' System Property nicht gesetzt");
            }
            this.adminFacadejndiName = prefix + EJB_TMO_ADMIN_FACADE;
        }
        return this.adminFacadejndiName;
    }

    public void setAdminFacadeJndiName(String jndiName) {
        this.adminFacadejndiName = jndiName;
    }

    public void setJndiPrefix(String jndiPrefix) {
        this.adminFacadejndiName = jndiPrefix + EJB_TMO_ADMIN_FACADE;
    }

    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
    }

    private String getContent(String filePath) throws IOException {
        GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(filePath)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int read = ((InputStream)is).read(buffer);
        while (read >= 0) {
            baos.write(buffer, 0, read);
            read = ((InputStream)is).read(buffer);
        }
        baos.close();
        String xmlStructure = new String(baos.toByteArray());
        return xmlStructure;
    }

    private Properties getResources(String filePath) throws IOException {
        Properties props = new Properties();
        props.load(new BufferedInputStream(new FileInputStream(filePath)));
        return props;
    }

    public static void main(String[] args) throws Exception {
        ModelDeployer deployer = new ModelDeployer();
        if (args.length > 0) {
            deployer.setJndiPrefix(args[0]);
            deployer.deployModel();
        }
        if (args.length > 1) {
            deployer.setResourcesPath(args[1]);
            deployer.deployResources(Locale.GERMAN);
            deployer.deployResources(Locale.FRENCH);
        }
        if (args.length > 2) {
            for (int i = 2; i < args.length; ++i) {
                String variant = args[i];
                deployer.deployResources(Locale.GERMAN, variant);
                deployer.deployResources(Locale.FRENCH, variant);
            }
        }
    }
}

