/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.SystemEventListener;
import ch.dvbern.tax.common.presentation.web.util.ActionHelper;
import ch.dvbern.tax.common.transfer.dto.SystemEventDTO;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class SystemEventsManager {
    private static Logger log = Logger.getLogger((Class)SystemEventsManager.class);
    private static SystemEventsManager instance;
    private Collection listeners = new LinkedList();

    private SystemEventsManager() {
    }

    public static synchronized SystemEventsManager getInstance() {
        if (instance == null) {
            instance = new SystemEventsManager();
        }
        return instance;
    }

    public void refresh() {
        Collection events = ActionHelper.getTmo().getSystemEvents();
        Iterator it = events.iterator();
        while (it.hasNext()) {
            SystemEventDTO ev = (SystemEventDTO)it.next();
            this.notifyListeners(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemEventListener(SystemEventListener li) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(li);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SystemEventListener added: " + li + " " + this.listeners.size() + " listeners listening"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSystemEventListener(SystemEventListener li) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(li);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removed SystemEventListener: " + li + " " + this.listeners.size() + " listeners listening"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(SystemEventDTO ev) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("notifing " + this.listeners.size() + " listeners about a system event type=" + ev.getType()));
        }
        Collection collection = this.listeners;
        synchronized (collection) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                SystemEventListener li = (SystemEventListener)it.next();
                try {
                    li.systemEvent(ev);
                }
                catch (Exception e) {
                    log.error((Object)"SystemEventListener callback failed", (Throwable)e);
                }
            }
        }
    }
}

