/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class IOUtil {
    private static final Logger log = Logger.getLogger((Class)IOUtil.class);

    private IOUtil() {
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, File out) throws IOException {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(out));
            IOUtil.copy(in, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(os);
            throw throwable;
        }
        IOUtil.closeSilent(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File in, OutputStream out) throws IOException {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(in));
            IOUtil.copy((InputStream)is, out);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(is);
            throw throwable;
        }
        IOUtil.closeSilent(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File in, File out) throws IOException {
        if (in.equals(out)) {
            return;
        }
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(in));
            os = new BufferedOutputStream(new FileOutputStream(out));
            IOUtil.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(is);
            IOUtil.closeSilent(os);
            throw throwable;
        }
        IOUtil.closeSilent(is);
        IOUtil.closeSilent(os);
    }

    public static void closeSilent(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                log.warn((Object)"can't close input stream", (Throwable)e);
            }
        }
    }

    public static void closeSilent(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                log.warn((Object)"can't close output stream", (Throwable)e);
            }
        }
    }

    public static void closeSilent(ZipFile zf) {
        if (zf != null) {
            try {
                zf.close();
            }
            catch (Exception e) {
                log.warn((Object)"can't close input stream", (Throwable)e);
            }
        }
    }

    public static void deleteSilent(File file) {
        if (file != null) {
            try {
                file.delete();
            }
            catch (Exception e) {
                log.warn((Object)"can't delete file", (Throwable)e);
            }
        }
    }

    public static void deleteOnExitSilent(File file) {
        if (file != null) {
            try {
                file.deleteOnExit();
            }
            catch (Exception e) {
                log.warn((Object)"can't mark file for deletion on exit", (Throwable)e);
            }
        }
    }
}

